/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.payload.ObjectPayload;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.utils.Decode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class GetPubkey
extends ObjectPayload {
    private static final long serialVersionUID = -3634516646972610180L;
    private long stream;
    private byte[] ripeTag;

    public GetPubkey(BitmessageAddress address) {
        super(address.getVersion());
        this.stream = address.getStream();
        this.ripeTag = address.getVersion() < 4L ? address.getRipe() : address.getTag();
    }

    private GetPubkey(long version, long stream, byte[] ripeOrTag) {
        super(version);
        this.stream = stream;
        this.ripeTag = ripeOrTag;
    }

    public static GetPubkey read(InputStream is, long stream, int length, long version) throws IOException {
        return new GetPubkey(version, stream, Decode.bytes(is, length));
    }

    public byte[] getRipeTag() {
        return this.ripeTag;
    }

    @Override
    public ObjectType getType() {
        return ObjectType.GET_PUBKEY;
    }

    @Override
    public long getStream() {
        return this.stream;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        stream.write(this.ripeTag);
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.put(this.ripeTag);
    }
}

