/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.payload.ObjectPayload;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.utils.Decode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class GenericPayload
extends ObjectPayload {
    private static final long serialVersionUID = -912314085064185940L;
    private long stream;
    private byte[] data;

    public GenericPayload(long version, long stream, byte[] data) {
        super(version);
        this.stream = stream;
        this.data = data;
    }

    public static GenericPayload read(long version, long stream, InputStream is, int length) throws IOException {
        return new GenericPayload(version, stream, Decode.bytes(is, length));
    }

    @Override
    public ObjectType getType() {
        return null;
    }

    @Override
    public long getStream() {
        return this.stream;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        stream.write(this.data);
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.put(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericPayload that = (GenericPayload)o;
        if (this.stream != that.stream) {
            return false;
        }
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = (int)(this.stream ^ this.stream >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

