/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.exception.DecryptionFailedException;
import ch.dissem.bitmessage.utils.AccessCounter;
import ch.dissem.bitmessage.utils.Bytes;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Encode;
import ch.dissem.bitmessage.utils.Points;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoBox
implements Streamable {
    private static final long serialVersionUID = 7217659539975573852L;
    private static final Logger LOG = LoggerFactory.getLogger(CryptoBox.class);
    private final byte[] initializationVector;
    private final int curveType;
    private final byte[] R;
    private final byte[] mac;
    private byte[] encrypted;

    public CryptoBox(Streamable data, byte[] K) throws IOException {
        this(Encode.bytes(data), K);
    }

    public CryptoBox(byte[] data, byte[] K) throws IOException {
        this.curveType = 714;
        this.initializationVector = Singleton.cryptography().randomBytes(16);
        byte[] r = Singleton.cryptography().randomBytes(32);
        this.R = Singleton.cryptography().createPublicKey(r);
        byte[] P = Singleton.cryptography().multiply(K, r);
        byte[] X = Points.getX(P);
        byte[] H = Singleton.cryptography().sha512(new byte[][]{X});
        byte[] key_e = Arrays.copyOfRange(H, 0, 32);
        byte[] key_m = Arrays.copyOfRange(H, 32, 64);
        this.encrypted = Singleton.cryptography().crypt(true, data, key_e, this.initializationVector);
        this.mac = this.calculateMac(key_m);
    }

    private CryptoBox(Builder builder) {
        this.initializationVector = builder.initializationVector;
        this.curveType = builder.curveType;
        this.R = Singleton.cryptography().createPoint(builder.xComponent, builder.yComponent);
        this.encrypted = builder.encrypted;
        this.mac = builder.mac;
    }

    public static CryptoBox read(InputStream stream, int length) throws IOException {
        AccessCounter counter = new AccessCounter();
        return new Builder().IV(Decode.bytes(stream, 16, counter)).curveType(Decode.uint16(stream, counter)).X(Decode.shortVarBytes(stream, counter)).Y(Decode.shortVarBytes(stream, counter)).encrypted(Decode.bytes(stream, length - counter.length() - 32)).MAC(Decode.bytes(stream, 32)).build();
    }

    public InputStream decrypt(byte[] k) throws DecryptionFailedException {
        byte[] P = Singleton.cryptography().multiply(this.R, k);
        byte[] H = Singleton.cryptography().sha512(new byte[][]{Arrays.copyOfRange(P, 1, 33)});
        byte[] key_e = Arrays.copyOfRange(H, 0, 32);
        byte[] key_m = Arrays.copyOfRange(H, 32, 64);
        if (!Arrays.equals(this.mac, this.calculateMac(key_m))) {
            throw new DecryptionFailedException();
        }
        return new ByteArrayInputStream(Singleton.cryptography().crypt(false, this.encrypted, key_e, this.initializationVector));
    }

    private byte[] calculateMac(byte[] key_m) {
        try {
            ByteArrayOutputStream macData = new ByteArrayOutputStream();
            this.writeWithoutMAC(macData);
            return Singleton.cryptography().mac(key_m, macData.toByteArray());
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    private void writeWithoutMAC(OutputStream out) throws IOException {
        out.write(this.initializationVector);
        Encode.int16((long)this.curveType, out);
        this.writeCoordinateComponent(out, Points.getX(this.R));
        this.writeCoordinateComponent(out, Points.getY(this.R));
        out.write(this.encrypted);
    }

    private void writeCoordinateComponent(OutputStream out, byte[] x) throws IOException {
        int offset = Bytes.numberOfLeadingZeros(x);
        int length = x.length - offset;
        Encode.int16((long)length, out);
        out.write(x, offset, length);
    }

    private void writeCoordinateComponent(ByteBuffer buffer, byte[] x) {
        int offset = Bytes.numberOfLeadingZeros(x);
        int length = x.length - offset;
        Encode.int16((long)length, buffer);
        buffer.put(x, offset, length);
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        this.writeWithoutMAC(stream);
        stream.write(this.mac);
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.put(this.initializationVector);
        Encode.int16((long)this.curveType, buffer);
        this.writeCoordinateComponent(buffer, Points.getX(this.R));
        this.writeCoordinateComponent(buffer, Points.getY(this.R));
        buffer.put(this.encrypted);
        buffer.put(this.mac);
    }

    public static final class Builder {
        private byte[] initializationVector;
        private int curveType;
        private byte[] xComponent;
        private byte[] yComponent;
        private byte[] encrypted;
        private byte[] mac;

        public Builder IV(byte[] initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public Builder curveType(int curveType) {
            if (curveType != 714) {
                LOG.trace("Unexpected curve type " + curveType);
            }
            this.curveType = curveType;
            return this;
        }

        public Builder X(byte[] xComponent) {
            this.xComponent = xComponent;
            return this;
        }

        public Builder Y(byte[] yComponent) {
            this.yComponent = yComponent;
            return this;
        }

        private Builder encrypted(byte[] encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public Builder MAC(byte[] mac) {
            this.mac = mac;
            return this;
        }

        public CryptoBox build() {
            return new CryptoBox(this);
        }
    }
}

