/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Encrypted;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.PlaintextHolder;
import ch.dissem.bitmessage.entity.payload.CryptoBox;
import ch.dissem.bitmessage.entity.payload.ObjectPayload;
import ch.dissem.bitmessage.exception.DecryptionFailedException;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.IOException;
import java.util.Objects;

public abstract class Broadcast
extends ObjectPayload
implements Encrypted,
PlaintextHolder {
    private static final long serialVersionUID = 4064521827582239069L;
    protected final long stream;
    protected CryptoBox encrypted;
    protected Plaintext plaintext;

    protected Broadcast(long version, long stream, CryptoBox encrypted, Plaintext plaintext) {
        super(version);
        this.stream = stream;
        this.encrypted = encrypted;
        this.plaintext = plaintext;
    }

    public static long getVersion(BitmessageAddress address) {
        return address.getVersion() < 4L ? 4L : 5L;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public byte[] getSignature() {
        return this.plaintext.getSignature();
    }

    @Override
    public void setSignature(byte[] signature) {
        this.plaintext.setSignature(signature);
    }

    @Override
    public long getStream() {
        return this.stream;
    }

    @Override
    public Plaintext getPlaintext() {
        return this.plaintext;
    }

    @Override
    public void encrypt(byte[] publicKey) throws IOException {
        this.encrypted = new CryptoBox(this.plaintext, publicKey);
    }

    public void encrypt() throws IOException {
        this.encrypt(Singleton.cryptography().createPublicKey(this.plaintext.getFrom().getPublicDecryptionKey()));
    }

    @Override
    public void decrypt(byte[] privateKey) throws IOException, DecryptionFailedException {
        this.plaintext = Plaintext.read(Plaintext.Type.BROADCAST, this.encrypted.decrypt(privateKey));
    }

    public void decrypt(BitmessageAddress address) throws IOException, DecryptionFailedException {
        this.decrypt(address.getPublicDecryptionKey());
    }

    @Override
    public boolean isDecrypted() {
        return this.plaintext != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Broadcast broadcast = (Broadcast)o;
        return this.stream == broadcast.stream && (Objects.equals(this.encrypted, broadcast.encrypted) || Objects.equals(this.plaintext, broadcast.plaintext));
    }

    public int hashCode() {
        return Objects.hash(this.stream);
    }
}

