/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity;

import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.utils.Encode;
import ch.dissem.bitmessage.utils.UnixTime;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class Version
implements MessagePayload {
    private static final long serialVersionUID = 7219240857343176567L;
    private final int version;
    private final long services;
    private final long timestamp;
    private final NetworkAddress addrRecv;
    private final NetworkAddress addrFrom;
    private final long nonce;
    private final String userAgent;
    private final long[] streams;

    private Version(Builder builder) {
        this.version = builder.version;
        this.services = builder.services;
        this.timestamp = builder.timestamp;
        this.addrRecv = builder.addrRecv;
        this.addrFrom = builder.addrFrom;
        this.nonce = builder.nonce;
        this.userAgent = builder.userAgent;
        this.streams = builder.streamNumbers;
    }

    public int getVersion() {
        return this.version;
    }

    public long getServices() {
        return this.services;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public NetworkAddress getAddrRecv() {
        return this.addrRecv;
    }

    public NetworkAddress getAddrFrom() {
        return this.addrFrom;
    }

    public long getNonce() {
        return this.nonce;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public long[] getStreams() {
        return this.streams;
    }

    @Override
    public MessagePayload.Command getCommand() {
        return MessagePayload.Command.VERSION;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        Encode.int32((long)this.version, stream);
        Encode.int64(this.services, stream);
        Encode.int64(this.timestamp, stream);
        this.addrRecv.write(stream, true);
        this.addrFrom.write(stream, true);
        Encode.int64(this.nonce, stream);
        Encode.varString(this.userAgent, stream);
        Encode.varIntList(this.streams, stream);
    }

    @Override
    public void write(ByteBuffer buffer) {
        Encode.int32((long)this.version, buffer);
        Encode.int64(this.services, buffer);
        Encode.int64(this.timestamp, buffer);
        this.addrRecv.write(buffer, true);
        this.addrFrom.write(buffer, true);
        Encode.int64(this.nonce, buffer);
        Encode.varString(this.userAgent, buffer);
        Encode.varIntList(this.streams, buffer);
    }

    public static final class Builder {
        private int version;
        private long services;
        private long timestamp;
        private NetworkAddress addrRecv;
        private NetworkAddress addrFrom;
        private long nonce;
        private String userAgent;
        private long[] streamNumbers;

        public Builder defaults(long clientNonce) {
            this.version = 3;
            this.services = 1L;
            this.timestamp = UnixTime.now();
            this.userAgent = "/Jabit:0.0.1/";
            this.streamNumbers = new long[]{1L};
            this.nonce = clientNonce;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder services(long services) {
            this.services = services;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder addrRecv(NetworkAddress addrRecv) {
            this.addrRecv = addrRecv;
            return this;
        }

        public Builder addrFrom(NetworkAddress addrFrom) {
            this.addrFrom = addrFrom;
            return this;
        }

        public Builder nonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder streams(long ... streamNumbers) {
            this.streamNumbers = streamNumbers;
            return this;
        }

        public Version build() {
            return new Version(this);
        }
    }
}

