/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.ObjectMessage;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.entity.valueobject.Label;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Encode;
import ch.dissem.bitmessage.utils.Singleton;
import ch.dissem.bitmessage.utils.TTL;
import ch.dissem.bitmessage.utils.UnixTime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;

public class Plaintext
implements Streamable {
    private static final long serialVersionUID = -5325729856394951079L;
    private final Type type;
    private final BitmessageAddress from;
    private final long encoding;
    private final byte[] message;
    private final byte[] ackData;
    private ObjectMessage ackMessage;
    private Object id;
    private InventoryVector inventoryVector;
    private BitmessageAddress to;
    private byte[] signature;
    private Status status;
    private Long sent;
    private Long received;
    private Set<Label> labels;
    private byte[] initialHash;
    private long ttl;
    private int retries;
    private Long nextTry;

    private Plaintext(Builder builder) {
        this.id = builder.id;
        this.inventoryVector = builder.inventoryVector;
        this.type = builder.type;
        this.from = builder.from;
        this.to = builder.to;
        this.encoding = builder.encoding;
        this.message = builder.message;
        this.ackData = builder.ackData;
        if (builder.ackMessage != null && builder.ackMessage.length > 0) {
            this.ackMessage = Factory.getObjectMessage(3, new ByteArrayInputStream(builder.ackMessage), builder.ackMessage.length);
        }
        this.signature = builder.signature;
        this.status = builder.status;
        this.sent = builder.sent;
        this.received = builder.received;
        this.labels = builder.labels;
        this.ttl = builder.ttl;
        this.retries = builder.retries;
        this.nextTry = builder.nextTry;
    }

    public static Plaintext read(Type type, InputStream in) throws IOException {
        return Plaintext.readWithoutSignature(type, in).signature(Decode.varBytes(in)).received(UnixTime.now()).build();
    }

    public static Builder readWithoutSignature(Type type, InputStream in) throws IOException {
        long version = Decode.varInt(in);
        return new Builder(type).addressVersion(version).stream(Decode.varInt(in)).behaviorBitfield(Decode.int32(in)).publicSigningKey(Decode.bytes(in, 64)).publicEncryptionKey(Decode.bytes(in, 64)).nonceTrialsPerByte(version >= 3L ? Decode.varInt(in) : 0L).extraBytes(version >= 3L ? Decode.varInt(in) : 0L).destinationRipe(type == Type.MSG ? Decode.bytes(in, 20) : null).encoding(Decode.varInt(in)).message(Decode.varBytes(in)).ackMessage(type == Type.MSG ? Decode.varBytes(in) : null);
    }

    public InventoryVector getInventoryVector() {
        return this.inventoryVector;
    }

    public void setInventoryVector(InventoryVector inventoryVector) {
        this.inventoryVector = inventoryVector;
    }

    public Type getType() {
        return this.type;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public BitmessageAddress getFrom() {
        return this.from;
    }

    public BitmessageAddress getTo() {
        return this.to;
    }

    public void setTo(BitmessageAddress to) {
        if (this.to.getVersion() != 0L) {
            throw new IllegalStateException("Correct address already set");
        }
        if (!Arrays.equals(this.to.getRipe(), to.getRipe())) {
            throw new IllegalArgumentException("RIPEs don't match");
        }
        this.to = to;
    }

    public Set<Label> getLabels() {
        return this.labels;
    }

    public long getStream() {
        return this.from.getStream();
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public boolean isUnread() {
        for (Label label : this.labels) {
            if (label.getType() != Label.Type.UNREAD) continue;
            return true;
        }
        return false;
    }

    public void write(OutputStream out, boolean includeSignature) throws IOException {
        Encode.varInt(this.from.getVersion(), out);
        Encode.varInt(this.from.getStream(), out);
        Encode.int32((long)this.from.getPubkey().getBehaviorBitfield(), out);
        out.write(this.from.getPubkey().getSigningKey(), 1, 64);
        out.write(this.from.getPubkey().getEncryptionKey(), 1, 64);
        if (this.from.getVersion() >= 3L) {
            Encode.varInt(this.from.getPubkey().getNonceTrialsPerByte(), out);
            Encode.varInt(this.from.getPubkey().getExtraBytes(), out);
        }
        if (this.type == Type.MSG) {
            out.write(this.to.getRipe());
        }
        Encode.varInt(this.encoding, out);
        Encode.varInt((long)this.message.length, out);
        out.write(this.message);
        if (this.type == Type.MSG) {
            if (this.to.has(Pubkey.Feature.DOES_ACK) && this.getAckMessage() != null) {
                ByteArrayOutputStream ack = new ByteArrayOutputStream();
                this.getAckMessage().write(ack);
                Encode.varBytes(ack.toByteArray(), out);
            } else {
                Encode.varInt(0L, out);
            }
        }
        if (includeSignature) {
            if (this.signature == null) {
                Encode.varInt(0L, out);
            } else {
                Encode.varInt((long)this.signature.length, out);
                out.write(this.signature);
            }
        }
    }

    public void write(ByteBuffer buffer, boolean includeSignature) {
        Encode.varInt(this.from.getVersion(), buffer);
        Encode.varInt(this.from.getStream(), buffer);
        Encode.int32((long)this.from.getPubkey().getBehaviorBitfield(), buffer);
        buffer.put(this.from.getPubkey().getSigningKey(), 1, 64);
        buffer.put(this.from.getPubkey().getEncryptionKey(), 1, 64);
        if (this.from.getVersion() >= 3L) {
            Encode.varInt(this.from.getPubkey().getNonceTrialsPerByte(), buffer);
            Encode.varInt(this.from.getPubkey().getExtraBytes(), buffer);
        }
        if (this.type == Type.MSG) {
            buffer.put(this.to.getRipe());
        }
        Encode.varInt(this.encoding, buffer);
        Encode.varInt((long)this.message.length, buffer);
        buffer.put(this.message);
        if (this.type == Type.MSG) {
            if (this.to.has(Pubkey.Feature.DOES_ACK) && this.getAckMessage() != null) {
                Encode.varBytes(Encode.bytes(this.getAckMessage()), buffer);
            } else {
                Encode.varInt(0L, buffer);
            }
        }
        if (includeSignature) {
            if (this.signature == null) {
                Encode.varInt(0L, buffer);
            } else {
                Encode.varInt((long)this.signature.length, buffer);
                buffer.put(this.signature);
            }
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.write(out, true);
    }

    @Override
    public void write(ByteBuffer buffer) {
        this.write(buffer, true);
    }

    public Object getId() {
        return this.id;
    }

    public void setId(long id) {
        if (this.id != null) {
            throw new IllegalStateException("ID already set");
        }
        this.id = id;
    }

    public Long getSent() {
        return this.sent;
    }

    public Long getReceived() {
        return this.received;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getTTL() {
        return this.ttl;
    }

    public int getRetries() {
        return this.retries;
    }

    public Long getNextTry() {
        return this.nextTry;
    }

    public void updateNextTry() {
        if (this.nextTry == null) {
            if (this.sent != null && this.to.has(Pubkey.Feature.DOES_ACK)) {
                this.nextTry = UnixTime.now(this.ttl);
                ++this.retries;
            }
        } else {
            this.nextTry = this.nextTry + (long)(1 << this.retries) * this.ttl;
            ++this.retries;
        }
    }

    public String getSubject() {
        Scanner s = new Scanner((InputStream)new ByteArrayInputStream(this.message), "UTF-8");
        String firstLine = s.nextLine();
        if (this.encoding == 2L) {
            return firstLine.substring("Subject:".length()).trim();
        }
        if (firstLine.length() > 50) {
            return firstLine.substring(0, 50).trim() + "...";
        }
        return firstLine;
    }

    public String getText() {
        try {
            String text = new String(this.message, "UTF-8");
            if (this.encoding == 2L) {
                return text.substring(text.indexOf("\nBody:") + 6);
            }
            return text;
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plaintext plaintext = (Plaintext)o;
        return Objects.equals(this.encoding, plaintext.encoding) && Objects.equals(this.from, plaintext.from) && Arrays.equals(this.message, plaintext.message) && Objects.equals(this.getAckMessage(), plaintext.getAckMessage()) && Arrays.equals(this.to.getRipe(), plaintext.to.getRipe()) && Arrays.equals(this.signature, plaintext.signature) && Objects.equals((Object)this.status, (Object)plaintext.status) && Objects.equals(this.sent, plaintext.sent) && Objects.equals(this.received, plaintext.received) && Objects.equals(this.labels, plaintext.labels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.encoding, this.message, this.ackData, this.to, this.signature, this.status, this.sent, this.received, this.labels});
    }

    public void addLabels(Label ... labels) {
        if (labels != null) {
            Collections.addAll(this.labels, labels);
        }
    }

    public void addLabels(Collection<Label> labels) {
        if (labels != null) {
            for (Label label : labels) {
                this.labels.add(label);
            }
        }
    }

    public void removeLabel(Label.Type type) {
        Iterator<Label> iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            Label label = iterator.next();
            if (label.getType() != type) continue;
            iterator.remove();
        }
    }

    public byte[] getAckData() {
        return this.ackData;
    }

    public ObjectMessage getAckMessage() {
        if (this.ackMessage == null) {
            this.ackMessage = Factory.createAck(this);
        }
        return this.ackMessage;
    }

    public void setInitialHash(byte[] initialHash) {
        this.initialHash = initialHash;
    }

    public byte[] getInitialHash() {
        return this.initialHash;
    }

    public static final class Builder {
        private Object id;
        private InventoryVector inventoryVector;
        private Type type;
        private BitmessageAddress from;
        private BitmessageAddress to;
        private long addressVersion;
        private long stream;
        private int behaviorBitfield;
        private byte[] publicSigningKey;
        private byte[] publicEncryptionKey;
        private long nonceTrialsPerByte;
        private long extraBytes;
        private byte[] destinationRipe;
        private long encoding;
        private byte[] message = new byte[0];
        private byte[] ackData;
        private byte[] ackMessage;
        private byte[] signature;
        private long sent;
        private long received;
        private Status status;
        private Set<Label> labels = new HashSet<Label>();
        private long ttl;
        private int retries;
        private Long nextTry;

        public Builder(Type type) {
            this.type = type;
        }

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder IV(InventoryVector iv) {
            this.inventoryVector = iv;
            return this;
        }

        public Builder from(BitmessageAddress address) {
            this.from = address;
            return this;
        }

        public Builder to(BitmessageAddress address) {
            if (this.type != Type.MSG && this.to != null) {
                throw new IllegalArgumentException("recipient address only allowed for msg");
            }
            this.to = address;
            return this;
        }

        private Builder addressVersion(long addressVersion) {
            this.addressVersion = addressVersion;
            return this;
        }

        private Builder stream(long stream) {
            this.stream = stream;
            return this;
        }

        private Builder behaviorBitfield(int behaviorBitfield) {
            this.behaviorBitfield = behaviorBitfield;
            return this;
        }

        private Builder publicSigningKey(byte[] publicSigningKey) {
            this.publicSigningKey = publicSigningKey;
            return this;
        }

        private Builder publicEncryptionKey(byte[] publicEncryptionKey) {
            this.publicEncryptionKey = publicEncryptionKey;
            return this;
        }

        private Builder nonceTrialsPerByte(long nonceTrialsPerByte) {
            this.nonceTrialsPerByte = nonceTrialsPerByte;
            return this;
        }

        private Builder extraBytes(long extraBytes) {
            this.extraBytes = extraBytes;
            return this;
        }

        private Builder destinationRipe(byte[] ripe) {
            if (this.type != Type.MSG && ripe != null) {
                throw new IllegalArgumentException("ripe only allowed for msg");
            }
            this.destinationRipe = ripe;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            this.encoding = encoding.getCode();
            return this;
        }

        private Builder encoding(long encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder message(String subject, String message) {
            try {
                this.encoding = Encoding.SIMPLE.getCode();
                this.message = ("Subject:" + subject + '\n' + "Body:" + message).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ApplicationException(e);
            }
            return this;
        }

        public Builder message(byte[] message) {
            this.message = message;
            return this;
        }

        public Builder ackMessage(byte[] ack) {
            if (this.type != Type.MSG && ack != null) {
                throw new IllegalArgumentException("ackMessage only allowed for msg");
            }
            this.ackMessage = ack;
            return this;
        }

        public Builder ackData(byte[] ackData) {
            if (this.type != Type.MSG && ackData != null) {
                throw new IllegalArgumentException("ackMessage only allowed for msg");
            }
            this.ackData = ackData;
            return this;
        }

        public Builder signature(byte[] signature) {
            this.signature = signature;
            return this;
        }

        public Builder sent(long sent) {
            this.sent = sent;
            return this;
        }

        public Builder received(long received) {
            this.received = received;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder labels(Collection<Label> labels) {
            this.labels.addAll(labels);
            return this;
        }

        public Builder ttl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder retries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder nextTry(Long nextTry) {
            this.nextTry = nextTry;
            return this;
        }

        public Plaintext build() {
            if (this.from == null) {
                this.from = new BitmessageAddress(Factory.createPubkey(this.addressVersion, this.stream, this.publicSigningKey, this.publicEncryptionKey, this.nonceTrialsPerByte, this.extraBytes, this.behaviorBitfield));
            }
            if (this.to == null && this.type != Type.BROADCAST && this.destinationRipe != null) {
                this.to = new BitmessageAddress(0L, 0L, this.destinationRipe);
            }
            if (this.type == Type.MSG && this.ackMessage == null && this.ackData == null) {
                this.ackData = Singleton.cryptography().randomBytes(32);
            }
            if (this.ttl <= 0L) {
                this.ttl = TTL.msg();
            }
            return new Plaintext(this);
        }
    }

    public static enum Type {
        MSG,
        BROADCAST;

    }

    public static enum Status {
        DRAFT,
        PUBKEY_REQUESTED,
        DOING_PROOF_OF_WORK,
        SENT,
        SENT_ACKNOWLEDGED,
        RECEIVED;

    }

    public static enum Encoding {
        IGNORE(0L),
        TRIVIAL(1L),
        SIMPLE(2L);

        long code;

        private Encoding(long code) {
            this.code = code;
        }

        public long getCode() {
            return this.code;
        }
    }
}

