/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity;

import ch.dissem.bitmessage.entity.Encrypted;
import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.payload.ObjectPayload;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.entity.valueobject.PrivateKey;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.exception.DecryptionFailedException;
import ch.dissem.bitmessage.utils.Bytes;
import ch.dissem.bitmessage.utils.Encode;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class ObjectMessage
implements MessagePayload {
    private static final long serialVersionUID = 2495752480120659139L;
    private byte[] nonce;
    private long expiresTime;
    private long objectType;
    private long version;
    private long stream;
    private ObjectPayload payload;
    private byte[] payloadBytes;

    private ObjectMessage(Builder builder) {
        this.nonce = builder.nonce;
        this.expiresTime = builder.expiresTime;
        this.objectType = builder.objectType;
        this.version = builder.payload.getVersion();
        this.stream = builder.streamNumber > 0L ? builder.streamNumber : builder.payload.getStream();
        this.payload = builder.payload;
    }

    @Override
    public MessagePayload.Command getCommand() {
        return MessagePayload.Command.OBJECT;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public long getExpiresTime() {
        return this.expiresTime;
    }

    public long getType() {
        return this.objectType;
    }

    public ObjectPayload getPayload() {
        return this.payload;
    }

    public long getVersion() {
        return this.version;
    }

    public long getStream() {
        return this.stream;
    }

    public InventoryVector getInventoryVector() {
        return new InventoryVector(Bytes.truncate(Singleton.cryptography().doubleSha512(this.nonce, this.getPayloadBytesWithoutNonce()), 32));
    }

    private boolean isEncrypted() {
        return this.payload instanceof Encrypted && !((Encrypted)((Object)this.payload)).isDecrypted();
    }

    public boolean isSigned() {
        return this.payload.isSigned();
    }

    private byte[] getBytesToSign() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeHeaderWithoutNonce(out);
            this.payload.writeBytesToSign(out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    public void sign(PrivateKey key) {
        if (this.payload.isSigned()) {
            this.payload.setSignature(Singleton.cryptography().getSignature(this.getBytesToSign(), key));
        }
    }

    public void decrypt(PrivateKey key) throws IOException, DecryptionFailedException {
        if (this.payload instanceof Encrypted) {
            ((Encrypted)((Object)this.payload)).decrypt(key.getPrivateEncryptionKey());
        }
    }

    public void decrypt(byte[] privateEncryptionKey) throws IOException, DecryptionFailedException {
        if (this.payload instanceof Encrypted) {
            ((Encrypted)((Object)this.payload)).decrypt(privateEncryptionKey);
        }
    }

    public void encrypt(byte[] publicEncryptionKey) throws IOException {
        if (this.payload instanceof Encrypted) {
            ((Encrypted)((Object)this.payload)).encrypt(publicEncryptionKey);
        }
    }

    public void encrypt(Pubkey publicKey) {
        try {
            if (this.payload instanceof Encrypted) {
                ((Encrypted)((Object)this.payload)).encrypt(publicKey.getEncryptionKey());
            }
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    public boolean isSignatureValid(Pubkey pubkey) throws IOException {
        if (this.isEncrypted()) {
            throw new IllegalStateException("Payload must be decrypted first");
        }
        return Singleton.cryptography().isSignatureValid(this.getBytesToSign(), this.payload.getSignature(), pubkey);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        if (this.nonce == null) {
            out.write(new byte[8]);
        } else {
            out.write(this.nonce);
        }
        out.write(this.getPayloadBytesWithoutNonce());
    }

    @Override
    public void write(ByteBuffer buffer) {
        if (this.nonce == null) {
            buffer.put(new byte[8]);
        } else {
            buffer.put(this.nonce);
        }
        buffer.put(this.getPayloadBytesWithoutNonce());
    }

    private void writeHeaderWithoutNonce(OutputStream out) throws IOException {
        Encode.int64(this.expiresTime, out);
        Encode.int32(this.objectType, out);
        Encode.varInt(this.version, out);
        Encode.varInt(this.stream, out);
    }

    public byte[] getPayloadBytesWithoutNonce() {
        try {
            if (this.payloadBytes == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.writeHeaderWithoutNonce(out);
                this.payload.write(out);
                this.payloadBytes = out.toByteArray();
            }
            return this.payloadBytes;
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMessage that = (ObjectMessage)o;
        return this.expiresTime == that.expiresTime && this.objectType == that.objectType && this.version == that.version && this.stream == that.stream && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.nonce);
        result = 31 * result + (int)(this.expiresTime ^ this.expiresTime >>> 32);
        result = 31 * result + (int)(this.objectType ^ this.objectType >>> 32);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (int)(this.stream ^ this.stream >>> 32);
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private byte[] nonce;
        private long expiresTime;
        private long objectType = -1L;
        private long streamNumber;
        private ObjectPayload payload;

        public Builder nonce(byte[] nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder expiresTime(long expiresTime) {
            this.expiresTime = expiresTime;
            return this;
        }

        public Builder objectType(long objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType.getNumber();
            return this;
        }

        public Builder stream(long streamNumber) {
            this.streamNumber = streamNumber;
            return this;
        }

        public Builder payload(ObjectPayload payload) {
            this.payload = payload;
            if (this.objectType == -1L) {
                this.objectType = payload.getType().getNumber();
            }
            return this;
        }

        public ObjectMessage build() {
            return new ObjectMessage(this);
        }
    }
}

