/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity;

import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.utils.Encode;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class NetworkMessage
implements Streamable {
    private static final long serialVersionUID = 702708857104464809L;
    public static final int MAGIC = -373377831;
    public static final byte[] MAGIC_BYTES = ByteBuffer.allocate(4).putInt(-373377831).array();
    private final MessagePayload payload;

    public NetworkMessage(MessagePayload payload) {
        this.payload = payload;
    }

    private byte[] getChecksum(byte[] bytes) throws NoSuchProviderException, NoSuchAlgorithmException {
        byte[] d = Singleton.cryptography().sha512(new byte[][]{bytes});
        return new byte[]{d[0], d[1], d[2], d[3]};
    }

    public MessagePayload getPayload() {
        return this.payload;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Encode.int32(-373377831L, out);
        String command = this.payload.getCommand().name().toLowerCase();
        out.write(command.getBytes("ASCII"));
        for (int i = command.length(); i < 12; ++i) {
            out.write(0);
        }
        byte[] payloadBytes = Encode.bytes(this.payload);
        Encode.int32((long)payloadBytes.length, out);
        try {
            out.write(this.getChecksum(payloadBytes));
        }
        catch (GeneralSecurityException e) {
            throw new ApplicationException(e);
        }
        out.write(payloadBytes);
    }

    public ByteBuffer writeHeaderAndGetPayloadBuffer(ByteBuffer headerBuffer) {
        return ByteBuffer.wrap(this.writeHeader(headerBuffer));
    }

    @Override
    public void write(ByteBuffer buffer) {
        byte[] payloadBytes = this.writeHeader(buffer);
        buffer.put(payloadBytes);
    }

    private byte[] writeHeader(ByteBuffer out) {
        Encode.int32(-373377831L, out);
        String command = this.payload.getCommand().name().toLowerCase();
        try {
            out.put(command.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException(e);
        }
        for (int i = command.length(); i < 12; ++i) {
            out.put((byte)0);
        }
        byte[] payloadBytes = Encode.bytes(this.payload);
        Encode.int32((long)payloadBytes.length, out);
        try {
            out.put(this.getChecksum(payloadBytes));
        }
        catch (GeneralSecurityException e) {
            throw new ApplicationException(e);
        }
        return payloadBytes;
    }
}

