/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity;

import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.utils.Encode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class Inv
implements MessagePayload {
    private static final long serialVersionUID = 3662992522956947145L;
    private List<InventoryVector> inventory;

    private Inv(Builder builder) {
        this.inventory = builder.inventory;
    }

    public List<InventoryVector> getInventory() {
        return this.inventory;
    }

    @Override
    public MessagePayload.Command getCommand() {
        return MessagePayload.Command.INV;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Encode.varInt((long)this.inventory.size(), out);
        for (InventoryVector iv : this.inventory) {
            iv.write(out);
        }
    }

    @Override
    public void write(ByteBuffer buffer) {
        Encode.varInt((long)this.inventory.size(), buffer);
        for (InventoryVector iv : this.inventory) {
            iv.write(buffer);
        }
    }

    public static final class Builder {
        private List<InventoryVector> inventory = new LinkedList<InventoryVector>();

        public Builder addInventoryVector(InventoryVector inventoryVector) {
            this.inventory.add(inventoryVector);
            return this;
        }

        public Builder inventory(List<InventoryVector> inventory) {
            this.inventory = inventory;
            return this;
        }

        public Inv build() {
            return new Inv(this);
        }
    }
}

