/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity;

import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.utils.AccessCounter;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Encode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class CustomMessage
implements MessagePayload {
    private static final long serialVersionUID = -8932056829480326011L;
    public static final String COMMAND_ERROR = "ERROR";
    private final String command;
    private final byte[] data;

    public CustomMessage(String command) {
        this.command = command;
        this.data = null;
    }

    public CustomMessage(String command, byte[] data) {
        this.command = command;
        this.data = data;
    }

    public static CustomMessage read(InputStream in, int length) throws IOException {
        AccessCounter counter = new AccessCounter();
        return new CustomMessage(Decode.varString(in, counter), Decode.bytes(in, length - counter.length()));
    }

    @Override
    public MessagePayload.Command getCommand() {
        return MessagePayload.Command.CUSTOM;
    }

    public String getCustomCommand() {
        return this.command;
    }

    public byte[] getData() {
        if (this.data != null) {
            return this.data;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.write(out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        if (this.data == null) {
            throw new ApplicationException("Tried to write custom message without data. Programmer: did you forget to override #write()?");
        }
        Encode.varString(this.command, out);
        out.write(this.data);
    }

    @Override
    public void write(ByteBuffer buffer) {
        if (this.data == null) {
            throw new ApplicationException("Tried to write custom message without data. Programmer: did you forget to override #write()?");
        }
        Encode.varString(this.command, buffer);
        buffer.put(this.data);
    }

    public boolean isError() {
        return COMMAND_ERROR.equals(this.command);
    }

    public static CustomMessage error(String message) {
        try {
            return new CustomMessage(COMMAND_ERROR, message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException(e);
        }
    }
}

