/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity;

import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.payload.V4Pubkey;
import ch.dissem.bitmessage.entity.valueobject.PrivateKey;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.utils.AccessCounter;
import ch.dissem.bitmessage.utils.Base58;
import ch.dissem.bitmessage.utils.Bytes;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Encode;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class BitmessageAddress
implements Serializable {
    private static final long serialVersionUID = 2386328540805994064L;
    private final long version;
    private final long stream;
    private final byte[] ripe;
    private final byte[] tag;
    private final byte[] publicDecryptionKey;
    private String address;
    private PrivateKey privateKey;
    private Pubkey pubkey;
    private String alias;
    private boolean subscribed;
    private boolean chan;

    BitmessageAddress(long version, long stream, byte[] ripe) {
        try {
            byte[] checksum;
            this.version = version;
            this.stream = stream;
            this.ripe = ripe;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Encode.varInt(version, os);
            Encode.varInt(stream, os);
            if (version < 4L) {
                checksum = Singleton.cryptography().sha512(os.toByteArray(), ripe);
                this.tag = null;
                this.publicDecryptionKey = Arrays.copyOfRange(checksum, 0, 32);
            } else {
                checksum = Singleton.cryptography().doubleSha512(os.toByteArray(), ripe);
                this.tag = Arrays.copyOfRange(checksum, 32, 64);
                this.publicDecryptionKey = Arrays.copyOfRange(checksum, 0, 32);
            }
            int offset = Bytes.numberOfLeadingZeros(ripe);
            os.write(ripe, offset, ripe.length - offset);
            byte[] checksum2 = Singleton.cryptography().doubleSha512(new byte[][]{os.toByteArray()});
            os.write(checksum2, 0, 4);
            this.address = "BM-" + Base58.encode(os.toByteArray());
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    public BitmessageAddress(Pubkey publicKey) {
        this(publicKey.getVersion(), publicKey.getStream(), publicKey.getRipe());
        this.pubkey = publicKey;
    }

    public BitmessageAddress(String address, String passphrase) {
        this(address);
        this.privateKey = new PrivateKey(this, passphrase);
        this.pubkey = this.privateKey.getPubkey();
        if (!Arrays.equals(this.ripe, this.privateKey.getPubkey().getRipe())) {
            throw new IllegalArgumentException("Wrong address or passphrase");
        }
    }

    public static BitmessageAddress chan(String address, String passphrase) {
        BitmessageAddress result = new BitmessageAddress(address, passphrase);
        result.chan = true;
        return result;
    }

    public static BitmessageAddress chan(long stream, String passphrase) {
        PrivateKey privateKey = new PrivateKey(4L, stream, passphrase);
        BitmessageAddress result = new BitmessageAddress(privateKey);
        result.chan = true;
        return result;
    }

    public static List<BitmessageAddress> deterministic(String passphrase, int numberOfAddresses, long version, long stream, boolean shorter) {
        ArrayList<BitmessageAddress> result = new ArrayList<BitmessageAddress>(numberOfAddresses);
        List<PrivateKey> privateKeys = PrivateKey.deterministic(passphrase, numberOfAddresses, version, stream, shorter);
        for (PrivateKey pk : privateKeys) {
            result.add(new BitmessageAddress(pk));
        }
        return result;
    }

    public BitmessageAddress(PrivateKey privateKey) {
        this(privateKey.getPubkey());
        this.privateKey = privateKey;
    }

    public BitmessageAddress(String address) {
        try {
            this.address = address;
            byte[] bytes = Base58.decode(address.substring(3));
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            AccessCounter counter = new AccessCounter();
            this.version = Decode.varInt(in, counter);
            this.stream = Decode.varInt(in, counter);
            this.ripe = Bytes.expand(Decode.bytes(in, bytes.length - counter.length() - 4), 20);
            byte[] checksum = Singleton.cryptography().doubleSha512(bytes, bytes.length - 4);
            byte[] expectedChecksum = Decode.bytes(in, 4);
            for (int i = 0; i < 4; ++i) {
                if (expectedChecksum[i] == checksum[i]) continue;
                throw new IllegalArgumentException("Checksum of address failed");
            }
            if (this.version < 4L) {
                checksum = Singleton.cryptography().sha512(Arrays.copyOfRange(bytes, 0, counter.length()), this.ripe);
                this.tag = null;
                this.publicDecryptionKey = Arrays.copyOfRange(checksum, 0, 32);
            } else {
                checksum = Singleton.cryptography().doubleSha512(Arrays.copyOfRange(bytes, 0, counter.length()), this.ripe);
                this.tag = Arrays.copyOfRange(checksum, 32, 64);
                this.publicDecryptionKey = Arrays.copyOfRange(checksum, 0, 32);
            }
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    public static byte[] calculateTag(long version, long stream, byte[] ripe) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Encode.varInt(version, out);
            Encode.varInt(stream, out);
            out.write(ripe);
            return Arrays.copyOfRange(Singleton.cryptography().doubleSha512(new byte[][]{out.toByteArray()}), 32, 64);
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    public long getStream() {
        return this.stream;
    }

    public long getVersion() {
        return this.version;
    }

    public Pubkey getPubkey() {
        return this.pubkey;
    }

    public void setPubkey(Pubkey pubkey) {
        if (pubkey instanceof V4Pubkey && !Arrays.equals(this.tag, ((V4Pubkey)pubkey).getTag())) {
            throw new IllegalArgumentException("Pubkey has incompatible tag");
        }
        if (!Arrays.equals(this.ripe, pubkey.getRipe())) {
            throw new IllegalArgumentException("Pubkey has incompatible ripe");
        }
        this.pubkey = pubkey;
    }

    public byte[] getPublicDecryptionKey() {
        return this.publicDecryptionKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return this.alias == null ? this.address : this.alias;
    }

    public byte[] getRipe() {
        return this.ripe;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmessageAddress address = (BitmessageAddress)o;
        return Objects.equals(this.version, address.version) && Objects.equals(this.stream, address.stream) && Arrays.equals(this.ripe, address.ripe);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ripe);
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    public boolean isChan() {
        return this.chan;
    }

    public void setChan(boolean chan) {
        this.chan = chan;
    }

    public boolean has(Pubkey.Feature feature) {
        if (this.pubkey == null || feature == null) {
            return false;
        }
        return feature.isActive(this.pubkey.getBehaviorBitfield());
    }
}

