/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity;

import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.utils.Encode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Addr
implements MessagePayload {
    private static final long serialVersionUID = -5117688017050138720L;
    private final List<NetworkAddress> addresses;

    private Addr(Builder builder) {
        this.addresses = builder.addresses;
    }

    @Override
    public MessagePayload.Command getCommand() {
        return MessagePayload.Command.ADDR;
    }

    public List<NetworkAddress> getAddresses() {
        return this.addresses;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Encode.varInt((long)this.addresses.size(), out);
        for (NetworkAddress address : this.addresses) {
            address.write(out);
        }
    }

    @Override
    public void write(ByteBuffer buffer) {
        Encode.varInt((long)this.addresses.size(), buffer);
        for (NetworkAddress address : this.addresses) {
            address.write(buffer);
        }
    }

    public static final class Builder {
        private List<NetworkAddress> addresses = new ArrayList<NetworkAddress>();

        public Builder addresses(Collection<NetworkAddress> addresses) {
            this.addresses.addAll(addresses);
            return this;
        }

        public Builder addAddress(NetworkAddress address) {
            this.addresses.add(address);
            return this;
        }

        public Addr build() {
            return new Addr(this);
        }
    }
}

