/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Encrypted;
import ch.dissem.bitmessage.entity.ObjectMessage;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.PlaintextHolder;
import ch.dissem.bitmessage.entity.payload.Msg;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.ports.Cryptography;
import ch.dissem.bitmessage.ports.MessageRepository;
import ch.dissem.bitmessage.ports.ProofOfWorkEngine;
import ch.dissem.bitmessage.ports.ProofOfWorkRepository;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofOfWorkService
implements ProofOfWorkEngine.Callback,
InternalContext.ContextHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ProofOfWorkService.class);
    private Cryptography cryptography;
    private InternalContext ctx;
    private ProofOfWorkRepository powRepo;
    private MessageRepository messageRepo;

    public void doMissingProofOfWork(long delayInMilliseconds) {
        final List<byte[]> items = this.powRepo.getItems();
        if (items.isEmpty()) {
            return;
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                LOG.info("Doing POW for " + items.size() + " tasks.");
                for (byte[] initialHash : items) {
                    ProofOfWorkRepository.Item item = ProofOfWorkService.this.powRepo.getItem(initialHash);
                    ProofOfWorkService.this.cryptography.doProofOfWork(item.object, item.nonceTrialsPerByte, item.extraBytes, ProofOfWorkService.this);
                }
            }
        }, delayInMilliseconds);
    }

    public void doProofOfWork(ObjectMessage object) {
        this.doProofOfWork(null, object);
    }

    public void doProofOfWork(BitmessageAddress recipient, ObjectMessage object) {
        Pubkey pubkey = recipient == null ? null : recipient.getPubkey();
        long nonceTrialsPerByte = pubkey == null ? 1000L : pubkey.getNonceTrialsPerByte();
        long extraBytes = pubkey == null ? 1000L : pubkey.getExtraBytes();
        this.powRepo.putObject(object, nonceTrialsPerByte, extraBytes);
        if (object.getPayload() instanceof PlaintextHolder) {
            Plaintext plaintext = ((PlaintextHolder)((Object)object.getPayload())).getPlaintext();
            plaintext.setInitialHash(this.cryptography.getInitialHash(object));
            this.messageRepo.save(plaintext);
        }
        this.cryptography.doProofOfWork(object, nonceTrialsPerByte, extraBytes, this);
    }

    public void doProofOfWorkWithAck(Plaintext plaintext, long expirationTime) {
        ObjectMessage ack = plaintext.getAckMessage();
        this.messageRepo.save(plaintext);
        ProofOfWorkRepository.Item item = new ProofOfWorkRepository.Item(ack, 1000L, 1000L, expirationTime, plaintext);
        this.powRepo.putObject(item);
        this.cryptography.doProofOfWork(ack, 1000L, 1000L, this);
    }

    @Override
    public void onNonceCalculated(byte[] initialHash, byte[] nonce) {
        ProofOfWorkRepository.Item item = this.powRepo.getItem(initialHash);
        if (item.message == null) {
            ObjectMessage object = this.powRepo.getItem((byte[])initialHash).object;
            object.setNonce(nonce);
            Plaintext plaintext = this.messageRepo.getMessage(initialHash);
            if (plaintext != null) {
                plaintext.setInventoryVector(object.getInventoryVector());
                plaintext.updateNextTry();
                this.ctx.getLabeler().markAsSent(plaintext);
                this.messageRepo.save(plaintext);
            }
            try {
                this.ctx.getNetworkListener().receive(object);
            }
            catch (IOException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            this.ctx.getInventory().storeObject(object);
            this.ctx.getNetworkHandler().offer(object.getInventoryVector());
        } else {
            item.message.getAckMessage().setNonce(nonce);
            ObjectMessage object = new ObjectMessage.Builder().stream(item.message.getStream()).expiresTime(item.expirationTime).payload(new Msg(item.message)).build();
            if (object.isSigned()) {
                object.sign(item.message.getFrom().getPrivateKey());
            }
            if (object.getPayload() instanceof Encrypted) {
                object.encrypt(item.message.getTo().getPubkey());
            }
            this.doProofOfWork(item.message.getTo(), object);
        }
        this.powRepo.removeObject(initialHash);
    }

    @Override
    public void setContext(InternalContext ctx) {
        this.ctx = ctx;
        this.cryptography = Singleton.cryptography();
        this.powRepo = ctx.getProofOfWorkRepository();
        this.messageRepo = ctx.getMessageRepository();
    }
}

