/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage;

import ch.dissem.bitmessage.BitmessageContext;
import ch.dissem.bitmessage.DefaultMessageListener;
import ch.dissem.bitmessage.ProofOfWorkService;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Encrypted;
import ch.dissem.bitmessage.entity.ObjectMessage;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.payload.Broadcast;
import ch.dissem.bitmessage.entity.payload.GetPubkey;
import ch.dissem.bitmessage.entity.payload.Msg;
import ch.dissem.bitmessage.entity.payload.ObjectPayload;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.payload.V4Pubkey;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.ports.AddressRepository;
import ch.dissem.bitmessage.ports.Cryptography;
import ch.dissem.bitmessage.ports.CustomCommandHandler;
import ch.dissem.bitmessage.ports.Inventory;
import ch.dissem.bitmessage.ports.Labeler;
import ch.dissem.bitmessage.ports.MessageRepository;
import ch.dissem.bitmessage.ports.NetworkHandler;
import ch.dissem.bitmessage.ports.NodeRegistry;
import ch.dissem.bitmessage.ports.ProofOfWorkEngine;
import ch.dissem.bitmessage.ports.ProofOfWorkRepository;
import ch.dissem.bitmessage.utils.Singleton;
import ch.dissem.bitmessage.utils.TTL;
import ch.dissem.bitmessage.utils.UnixTime;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalContext {
    private static final Logger LOG = LoggerFactory.getLogger(InternalContext.class);
    public static final long NETWORK_NONCE_TRIALS_PER_BYTE = 1000L;
    public static final long NETWORK_EXTRA_BYTES = 1000L;
    private final Cryptography cryptography;
    private final Inventory inventory;
    private final NodeRegistry nodeRegistry;
    private final NetworkHandler networkHandler;
    private final AddressRepository addressRepository;
    private final MessageRepository messageRepository;
    private final ProofOfWorkRepository proofOfWorkRepository;
    private final ProofOfWorkEngine proofOfWorkEngine;
    private final CustomCommandHandler customCommandHandler;
    private final ProofOfWorkService proofOfWorkService;
    private final Labeler labeler;
    private final NetworkHandler.MessageListener networkListener;
    private final TreeSet<Long> streams = new TreeSet();
    private final int port;
    private final long clientNonce;
    private long connectionTTL;
    private int connectionLimit;

    public InternalContext(BitmessageContext.Builder builder) {
        this.cryptography = builder.cryptography;
        this.inventory = builder.inventory;
        this.nodeRegistry = builder.nodeRegistry;
        this.networkHandler = builder.networkHandler;
        this.addressRepository = builder.addressRepo;
        this.messageRepository = builder.messageRepo;
        this.proofOfWorkRepository = builder.proofOfWorkRepository;
        this.proofOfWorkService = new ProofOfWorkService();
        this.proofOfWorkEngine = builder.proofOfWorkEngine;
        this.clientNonce = this.cryptography.randomNonce();
        this.customCommandHandler = builder.customCommandHandler;
        this.port = builder.port;
        this.connectionLimit = builder.connectionLimit;
        this.connectionTTL = builder.connectionTTL;
        this.labeler = builder.labeler;
        this.networkListener = new DefaultMessageListener(this.labeler, builder.listener);
        Singleton.initialize(this.cryptography);
        for (BitmessageAddress address : this.addressRepository.getIdentities()) {
            this.streams.add(address.getStream());
        }
        for (BitmessageAddress address : this.addressRepository.getSubscriptions()) {
            this.streams.add(address.getStream());
        }
        if (this.streams.isEmpty()) {
            this.streams.add(1L);
        }
        this.init(this.cryptography, this.inventory, this.nodeRegistry, this.networkHandler, this.addressRepository, this.messageRepository, this.proofOfWorkRepository, this.proofOfWorkService, this.proofOfWorkEngine, this.customCommandHandler, builder.labeler, this.networkListener);
        for (BitmessageAddress identity : this.addressRepository.getIdentities()) {
            this.streams.add(identity.getStream());
        }
    }

    private void init(Object ... objects) {
        for (Object o : objects) {
            if (!(o instanceof ContextHolder)) continue;
            ((ContextHolder)o).setContext(this);
        }
    }

    public Cryptography getCryptography() {
        return this.cryptography;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public NodeRegistry getNodeRegistry() {
        return this.nodeRegistry;
    }

    public NetworkHandler getNetworkHandler() {
        return this.networkHandler;
    }

    public AddressRepository getAddressRepository() {
        return this.addressRepository;
    }

    public MessageRepository getMessageRepository() {
        return this.messageRepository;
    }

    public ProofOfWorkRepository getProofOfWorkRepository() {
        return this.proofOfWorkRepository;
    }

    public ProofOfWorkEngine getProofOfWorkEngine() {
        return this.proofOfWorkEngine;
    }

    public ProofOfWorkService getProofOfWorkService() {
        return this.proofOfWorkService;
    }

    public Labeler getLabeler() {
        return this.labeler;
    }

    public NetworkHandler.MessageListener getNetworkListener() {
        return this.networkListener;
    }

    public long[] getStreams() {
        long[] result = new long[this.streams.size()];
        int i = 0;
        for (long stream : this.streams) {
            result[i++] = stream;
        }
        return result;
    }

    public int getPort() {
        return this.port;
    }

    public void send(Plaintext plaintext) {
        if (plaintext.getAckMessage() != null) {
            long expires = UnixTime.now(plaintext.getTTL());
            LOG.info("Expires at " + expires);
            this.proofOfWorkService.doProofOfWorkWithAck(plaintext, expires);
        } else {
            this.send(plaintext.getFrom(), plaintext.getTo(), new Msg(plaintext), plaintext.getTTL());
        }
    }

    public void send(BitmessageAddress from, BitmessageAddress to, ObjectPayload payload, long timeToLive) {
        try {
            BitmessageAddress recipient = to != null ? to : from;
            long expires = UnixTime.now(timeToLive);
            LOG.info("Expires at " + expires);
            ObjectMessage object = new ObjectMessage.Builder().stream(recipient.getStream()).expiresTime(expires).payload(payload).build();
            if (object.isSigned()) {
                object.sign(from.getPrivateKey());
            }
            if (payload instanceof Broadcast) {
                ((Broadcast)payload).encrypt();
            } else if (payload instanceof Encrypted) {
                object.encrypt(recipient.getPubkey());
            }
            this.proofOfWorkService.doProofOfWork(to, object);
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    public void sendPubkey(BitmessageAddress identity, long targetStream) {
        try {
            long expires = UnixTime.now(TTL.pubkey());
            LOG.info("Expires at " + expires);
            ObjectMessage response = new ObjectMessage.Builder().stream(targetStream).expiresTime(expires).payload(identity.getPubkey()).build();
            response.sign(identity.getPrivateKey());
            response.encrypt(this.cryptography.createPublicKey(identity.getPublicDecryptionKey()));
            this.proofOfWorkService.doProofOfWork(response);
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    public void requestPubkey(BitmessageAddress contact) {
        BitmessageAddress stored = this.addressRepository.getAddress(contact.getAddress());
        this.tryToFindMatchingPubkey(contact);
        if (contact.getPubkey() != null) {
            if (stored != null) {
                stored.setPubkey(contact.getPubkey());
                this.addressRepository.save(stored);
            } else {
                this.addressRepository.save(contact);
            }
            return;
        }
        if (stored == null) {
            this.addressRepository.save(contact);
        }
        long expires = UnixTime.now(TTL.getpubkey());
        LOG.info("Expires at " + expires);
        ObjectMessage request = new ObjectMessage.Builder().stream(contact.getStream()).expiresTime(expires).payload(new GetPubkey(contact)).build();
        this.proofOfWorkService.doProofOfWork(request);
    }

    private void tryToFindMatchingPubkey(BitmessageAddress address) {
        BitmessageAddress stored = this.addressRepository.getAddress(address.getAddress());
        if (stored != null) {
            address.setAlias(stored.getAlias());
            address.setSubscribed(stored.isSubscribed());
        }
        for (ObjectMessage object : this.inventory.getObjects(address.getStream(), address.getVersion(), ObjectType.PUBKEY)) {
            try {
                Pubkey pubkey = (Pubkey)object.getPayload();
                if (address.getVersion() == 4L) {
                    V4Pubkey v4Pubkey = (V4Pubkey)pubkey;
                    if (!Arrays.equals(address.getTag(), v4Pubkey.getTag())) continue;
                    v4Pubkey.decrypt(address.getPublicDecryptionKey());
                    if (object.isSignatureValid(v4Pubkey)) {
                        address.setPubkey(v4Pubkey);
                        this.addressRepository.save(address);
                        break;
                    }
                    LOG.info("Found pubkey for " + address + " but signature is invalid");
                    continue;
                }
                if (!Arrays.equals(pubkey.getRipe(), address.getRipe())) continue;
                address.setPubkey(pubkey);
                this.addressRepository.save(address);
                break;
            }
            catch (Exception e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void resendUnacknowledged() {
        List<Plaintext> messages = this.messageRepository.findMessagesToResend();
        for (Plaintext message : messages) {
            this.send(message);
            this.messageRepository.save(message);
        }
    }

    public long getClientNonce() {
        return this.clientNonce;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public int getConnectionLimit() {
        return this.connectionLimit;
    }

    public CustomCommandHandler getCustomCommandHandler() {
        return this.customCommandHandler;
    }

    public static interface ContextHolder {
        public void setContext(InternalContext var1);
    }
}

