/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage;

import ch.dissem.bitmessage.BitmessageContext;
import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.ObjectMessage;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.payload.Broadcast;
import ch.dissem.bitmessage.entity.payload.GenericPayload;
import ch.dissem.bitmessage.entity.payload.GetPubkey;
import ch.dissem.bitmessage.entity.payload.Msg;
import ch.dissem.bitmessage.entity.payload.ObjectPayload;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.payload.V4Pubkey;
import ch.dissem.bitmessage.entity.payload.V5Broadcast;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.exception.DecryptionFailedException;
import ch.dissem.bitmessage.ports.Labeler;
import ch.dissem.bitmessage.ports.NetworkHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMessageListener
implements NetworkHandler.MessageListener,
InternalContext.ContextHolder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMessageListener.class);
    private final Labeler labeler;
    private final BitmessageContext.Listener listener;
    private InternalContext ctx;

    public DefaultMessageListener(Labeler labeler, BitmessageContext.Listener listener) {
        this.labeler = labeler;
        this.listener = listener;
    }

    @Override
    public void setContext(InternalContext context) {
        this.ctx = context;
    }

    @Override
    public void receive(ObjectMessage object) throws IOException {
        ObjectPayload payload = object.getPayload();
        if (payload.getType() == null) {
            if (payload instanceof GenericPayload) {
                this.receive((GenericPayload)payload);
            }
            return;
        }
        switch (payload.getType()) {
            case GET_PUBKEY: {
                this.receive(object, (GetPubkey)payload);
                break;
            }
            case PUBKEY: {
                this.receive(object, (Pubkey)payload);
                break;
            }
            case MSG: {
                this.receive(object, (Msg)payload);
                break;
            }
            case BROADCAST: {
                this.receive(object, (Broadcast)payload);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown payload type " + (Object)((Object)payload.getType()));
            }
        }
    }

    protected void receive(ObjectMessage object, GetPubkey getPubkey) {
        BitmessageAddress identity = this.ctx.getAddressRepository().findIdentity(getPubkey.getRipeTag());
        if (identity != null && identity.getPrivateKey() != null && !identity.isChan()) {
            LOG.info("Got pubkey request for identity " + identity);
            this.ctx.sendPubkey(identity, object.getStream());
        }
    }

    protected void receive(ObjectMessage object, Pubkey pubkey) throws IOException {
        try {
            BitmessageAddress address;
            if (pubkey instanceof V4Pubkey) {
                V4Pubkey v4Pubkey = (V4Pubkey)pubkey;
                address = this.ctx.getAddressRepository().findContact(v4Pubkey.getTag());
                if (address != null) {
                    v4Pubkey.decrypt(address.getPublicDecryptionKey());
                }
            } else {
                address = this.ctx.getAddressRepository().findContact(pubkey.getRipe());
            }
            if (address != null) {
                this.updatePubkey(address, pubkey);
            }
        }
        catch (DecryptionFailedException decryptionFailedException) {
            // empty catch block
        }
    }

    private void updatePubkey(BitmessageAddress address, Pubkey pubkey) {
        address.setPubkey(pubkey);
        LOG.info("Got pubkey for contact " + address);
        this.ctx.getAddressRepository().save(address);
        List<Plaintext> messages = this.ctx.getMessageRepository().findMessages(Plaintext.Status.PUBKEY_REQUESTED, address);
        LOG.info("Sending " + messages.size() + " messages for contact " + address);
        for (Plaintext msg : messages) {
            this.ctx.getLabeler().markAsSending(msg);
            this.ctx.getMessageRepository().save(msg);
            this.ctx.send(msg);
        }
    }

    protected void receive(ObjectMessage object, Msg msg) throws IOException {
        for (BitmessageAddress identity : this.ctx.getAddressRepository().getIdentities()) {
            try {
                msg.decrypt(identity.getPrivateKey().getPrivateEncryptionKey());
                Plaintext plaintext = msg.getPlaintext();
                plaintext.setTo(identity);
                if (!object.isSignatureValid(plaintext.getFrom().getPubkey())) {
                    LOG.warn("Msg with IV " + object.getInventoryVector() + " was successfully decrypted, but signature check failed. Ignoring.");
                    break;
                }
                this.receive(object.getInventoryVector(), plaintext);
                break;
            }
            catch (DecryptionFailedException decryptionFailedException) {
            }
        }
    }

    protected void receive(GenericPayload ack) {
        Plaintext msg;
        if (ack.getData().length == 32 && (msg = this.ctx.getMessageRepository().getMessageForAck(ack.getData())) != null) {
            this.ctx.getLabeler().markAsAcknowledged(msg);
            this.ctx.getMessageRepository().save(msg);
        }
    }

    protected void receive(ObjectMessage object, Broadcast broadcast) throws IOException {
        byte[] tag = broadcast instanceof V5Broadcast ? ((V5Broadcast)broadcast).getTag() : null;
        for (BitmessageAddress subscription : this.ctx.getAddressRepository().getSubscriptions(broadcast.getVersion())) {
            if (tag != null && !Arrays.equals(tag, subscription.getTag())) continue;
            try {
                broadcast.decrypt(subscription.getPublicDecryptionKey());
                if (!object.isSignatureValid(broadcast.getPlaintext().getFrom().getPubkey())) {
                    LOG.warn("Broadcast with IV " + object.getInventoryVector() + " was successfully decrypted, but signature check failed. Ignoring.");
                    continue;
                }
                this.receive(object.getInventoryVector(), broadcast.getPlaintext());
            }
            catch (DecryptionFailedException decryptionFailedException) {}
        }
    }

    protected void receive(InventoryVector iv, Plaintext msg) {
        ObjectMessage ack;
        msg.setInventoryVector(iv);
        this.labeler.setLabels(msg);
        this.ctx.getMessageRepository().save(msg);
        this.listener.receive(msg);
        this.updatePubkey(msg.getFrom(), msg.getFrom().getPubkey());
        if (msg.getType() == Plaintext.Type.MSG && msg.getTo().has(Pubkey.Feature.DOES_ACK) && (ack = msg.getAckMessage()) != null) {
            this.ctx.getInventory().storeObject(ack);
            this.ctx.getNetworkHandler().offer(ack.getInventoryVector());
        }
    }
}

