/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.CustomMessage;
import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.ObjectMessage;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.payload.Broadcast;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.valueobject.PrivateKey;
import ch.dissem.bitmessage.exception.DecryptionFailedException;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.ports.AddressRepository;
import ch.dissem.bitmessage.ports.Cryptography;
import ch.dissem.bitmessage.ports.CustomCommandHandler;
import ch.dissem.bitmessage.ports.DefaultLabeler;
import ch.dissem.bitmessage.ports.Inventory;
import ch.dissem.bitmessage.ports.Labeler;
import ch.dissem.bitmessage.ports.MessageRepository;
import ch.dissem.bitmessage.ports.MultiThreadedPOWEngine;
import ch.dissem.bitmessage.ports.NetworkHandler;
import ch.dissem.bitmessage.ports.NodeRegistry;
import ch.dissem.bitmessage.ports.ProofOfWorkEngine;
import ch.dissem.bitmessage.ports.ProofOfWorkRepository;
import ch.dissem.bitmessage.utils.Property;
import ch.dissem.bitmessage.utils.TTL;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmessageContext {
    public static final int CURRENT_VERSION = 3;
    private static final Logger LOG = LoggerFactory.getLogger(BitmessageContext.class);
    private final InternalContext ctx;
    private final Labeler labeler;
    private final boolean sendPubkeyOnIdentityCreation;

    private BitmessageContext(Builder builder) {
        if (builder.listener instanceof Listener.WithContext) {
            ((Listener.WithContext)builder.listener).setContext(this);
        }
        this.ctx = new InternalContext(builder);
        this.labeler = builder.labeler;
        this.ctx.getProofOfWorkService().doMissingProofOfWork(30000L);
        this.sendPubkeyOnIdentityCreation = builder.sendPubkeyOnIdentityCreation;
    }

    public AddressRepository addresses() {
        return this.ctx.getAddressRepository();
    }

    public MessageRepository messages() {
        return this.ctx.getMessageRepository();
    }

    public Labeler labeler() {
        return this.labeler;
    }

    public BitmessageAddress createIdentity(boolean shorter, Pubkey.Feature ... features) {
        BitmessageAddress identity = new BitmessageAddress(new PrivateKey(shorter, this.ctx.getStreams()[0], 1000L, 1000L, features));
        this.ctx.getAddressRepository().save(identity);
        if (this.sendPubkeyOnIdentityCreation) {
            this.ctx.sendPubkey(identity, identity.getStream());
        }
        return identity;
    }

    public BitmessageAddress joinChan(String passphrase, String address) {
        BitmessageAddress chan = BitmessageAddress.chan(address, passphrase);
        chan.setAlias(passphrase);
        this.ctx.getAddressRepository().save(chan);
        return chan;
    }

    public BitmessageAddress createChan(String passphrase) {
        BitmessageAddress chan = BitmessageAddress.chan(1L, passphrase);
        this.ctx.getAddressRepository().save(chan);
        return chan;
    }

    public List<BitmessageAddress> createDeterministicAddresses(String passphrase, int numberOfAddresses, long version, long stream, boolean shorter) {
        List<BitmessageAddress> result = BitmessageAddress.deterministic(passphrase, numberOfAddresses, version, stream, shorter);
        for (int i = 0; i < result.size(); ++i) {
            BitmessageAddress address = result.get(i);
            address.setAlias("deterministic (" + (i + 1) + ")");
            this.ctx.getAddressRepository().save(address);
        }
        return result;
    }

    public void broadcast(BitmessageAddress from, String subject, String message) {
        Plaintext msg = new Plaintext.Builder(Plaintext.Type.BROADCAST).from(from).message(subject, message).build();
        this.send(msg);
    }

    public void send(BitmessageAddress from, BitmessageAddress to, String subject, String message) {
        if (from.getPrivateKey() == null) {
            throw new IllegalArgumentException("'From' must be an identity, i.e. have a private key.");
        }
        Plaintext msg = new Plaintext.Builder(Plaintext.Type.MSG).from(from).to(to).message(subject, message).build();
        this.send(msg);
    }

    public void send(Plaintext msg) {
        if (msg.getFrom() == null || msg.getFrom().getPrivateKey() == null) {
            throw new IllegalArgumentException("'From' must be an identity, i.e. have a private key.");
        }
        this.labeler().markAsSending(msg);
        BitmessageAddress to = msg.getTo();
        if (to != null) {
            if (to.getPubkey() == null) {
                LOG.info("Public key is missing from recipient. Requesting.");
                this.ctx.requestPubkey(to);
            }
            if (to.getPubkey() == null) {
                this.ctx.getMessageRepository().save(msg);
            }
        }
        if (to == null || to.getPubkey() != null) {
            LOG.info("Sending message.");
            this.ctx.getMessageRepository().save(msg);
            if (msg.getType() == Plaintext.Type.MSG) {
                this.ctx.send(msg);
            } else {
                this.ctx.send(msg.getFrom(), to, Factory.getBroadcast(msg), msg.getTTL());
            }
        }
    }

    public void startup() {
        this.ctx.getNetworkHandler().start();
    }

    public void shutdown() {
        this.ctx.getNetworkHandler().stop();
    }

    public void synchronize(InetAddress host, int port, long timeoutInSeconds, boolean wait) {
        Future<?> future = this.ctx.getNetworkHandler().synchronize(host, port, timeoutInSeconds);
        if (wait) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                LOG.info("Thread was interrupted. Trying to shut down synchronization and returning.");
                future.cancel(true);
            }
            catch (CancellationException | ExecutionException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public CustomMessage send(InetAddress server, int port, CustomMessage request) {
        return this.ctx.getNetworkHandler().send(server, port, request);
    }

    public void cleanup() {
        this.ctx.getInventory().cleanup();
    }

    public void resendUnacknowledgedMessages() {
        this.ctx.resendUnacknowledged();
    }

    public boolean isRunning() {
        return this.ctx.getNetworkHandler().isRunning();
    }

    public void addContact(BitmessageAddress contact) {
        this.ctx.getAddressRepository().save(contact);
        if (contact.getPubkey() == null) {
            this.ctx.requestPubkey(contact);
        }
    }

    public void addSubscribtion(BitmessageAddress address) {
        address.setSubscribed(true);
        this.ctx.getAddressRepository().save(address);
        this.tryToFindBroadcastsForAddress(address);
    }

    private void tryToFindBroadcastsForAddress(BitmessageAddress address) {
        for (ObjectMessage object : this.ctx.getInventory().getObjects(address.getStream(), Broadcast.getVersion(address), ObjectType.BROADCAST)) {
            try {
                Broadcast broadcast = (Broadcast)object.getPayload();
                broadcast.decrypt(address);
                this.ctx.getNetworkListener().receive(object);
            }
            catch (DecryptionFailedException broadcast) {
            }
            catch (Exception e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Property status() {
        return new Property("status", null, this.ctx.getNetworkHandler().getNetworkStatus(), new Property("unacknowledged", this.ctx.getMessageRepository().findMessagesToResend().size(), new Property[0]));
    }

    public InternalContext internals() {
        return this.ctx;
    }

    public static final class Builder {
        int port = 8444;
        Inventory inventory;
        NodeRegistry nodeRegistry;
        NetworkHandler networkHandler;
        AddressRepository addressRepo;
        MessageRepository messageRepo;
        ProofOfWorkRepository proofOfWorkRepository;
        ProofOfWorkEngine proofOfWorkEngine;
        Cryptography cryptography;
        CustomCommandHandler customCommandHandler;
        Labeler labeler;
        Listener listener;
        int connectionLimit = 150;
        long connectionTTL = 1800L;
        boolean sendPubkeyOnIdentityCreation = true;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder inventory(Inventory inventory) {
            this.inventory = inventory;
            return this;
        }

        public Builder nodeRegistry(NodeRegistry nodeRegistry) {
            this.nodeRegistry = nodeRegistry;
            return this;
        }

        public Builder networkHandler(NetworkHandler networkHandler) {
            this.networkHandler = networkHandler;
            return this;
        }

        public Builder addressRepo(AddressRepository addressRepo) {
            this.addressRepo = addressRepo;
            return this;
        }

        public Builder messageRepo(MessageRepository messageRepo) {
            this.messageRepo = messageRepo;
            return this;
        }

        public Builder powRepo(ProofOfWorkRepository proofOfWorkRepository) {
            this.proofOfWorkRepository = proofOfWorkRepository;
            return this;
        }

        public Builder cryptography(Cryptography cryptography) {
            this.cryptography = cryptography;
            return this;
        }

        public Builder customCommandHandler(CustomCommandHandler handler) {
            this.customCommandHandler = handler;
            return this;
        }

        public Builder proofOfWorkEngine(ProofOfWorkEngine proofOfWorkEngine) {
            this.proofOfWorkEngine = proofOfWorkEngine;
            return this;
        }

        public Builder labeler(Labeler labeler) {
            this.labeler = labeler;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder connectionLimit(int connectionLimit) {
            this.connectionLimit = connectionLimit;
            return this;
        }

        public Builder connectionTTL(int hours) {
            this.connectionTTL = (long)hours * 3600L;
            return this;
        }

        public Builder doNotSendPubkeyOnIdentityCreation() {
            this.sendPubkeyOnIdentityCreation = false;
            return this;
        }

        public Builder pubkeyTTL(long days) {
            if (days < 0L || days > 2419200L) {
                throw new IllegalArgumentException("TTL must be between 1 and 28 days");
            }
            TTL.pubkey(days);
            return this;
        }

        public BitmessageContext build() {
            this.nonNull("inventory", this.inventory);
            this.nonNull("nodeRegistry", this.nodeRegistry);
            this.nonNull("networkHandler", this.networkHandler);
            this.nonNull("addressRepo", this.addressRepo);
            this.nonNull("messageRepo", this.messageRepo);
            this.nonNull("proofOfWorkRepo", this.proofOfWorkRepository);
            if (this.proofOfWorkEngine == null) {
                this.proofOfWorkEngine = new MultiThreadedPOWEngine();
            }
            if (this.labeler == null) {
                this.labeler = new DefaultLabeler();
            }
            if (this.customCommandHandler == null) {
                this.customCommandHandler = new CustomCommandHandler(){

                    @Override
                    public MessagePayload handle(CustomMessage request) {
                        throw new IllegalStateException("Received custom request, but no custom command handler configured.");
                    }
                };
            }
            return new BitmessageContext(this);
        }

        private void nonNull(String name, Object o) {
            if (o == null) {
                throw new IllegalStateException(name + " must not be null");
            }
        }
    }

    public static interface Listener {
        public void receive(Plaintext var1);

        public static interface WithContext
        extends Listener {
            public void setContext(BitmessageContext var1);
        }
    }
}

