/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jscoverproxy;

import com.google.javascript.jscomp.parsing.Config;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jscover.ConfigurationCommon;
import jscover.report.Main;
import jscover.server.ConfigurationForServer;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

@Mojo(name="coverage", defaultPhase=LifecyclePhase.VERIFY)
public class JSCoverProxyMavenMojo
extends AbstractMojo {
    private ConfigurationForServer defaults = new ConfigurationForServer();
    @Parameter(required=true)
    private String baseUrl;
    @Parameter(defaultValue="coverage")
    private String reportName;
    @Parameter(required=true)
    private File outputDir;
    @Parameter
    private String cssSelectorForEndTest = ".jasmine-duration";
    @Parameter
    private String textForEndTest = "finished";
    @Parameter
    private File jsSrcDir;
    @Parameter
    private boolean generateXMLSUMMARY;
    @Parameter
    private boolean generateLCOV;
    @Parameter
    private boolean generateCOBERTURAXML;
    @Parameter
    private List<String> noInstruments;
    @Parameter
    private Config.LanguageMode ecmaVersion = this.defaults.getECMAVersion();
    @Parameter
    protected final List<String> instrumentPathArgs = new ArrayList<String>();
    @Parameter
    private boolean includeUnloadedJS = this.defaults.isIncludeUnloadedJS();
    @Parameter
    protected boolean detectCoalesce = this.defaults.isDetectCoalesce();
    @Parameter(defaultValue="60")
    private int timeout;
    @Parameter(property="skipTests")
    protected boolean skipTests;
    @Parameter(property="maven.test.skip")
    protected boolean mvnTestSkip;

    private HtmlUnitDriver getWebClient(int portForJSCoverProxy) {
        Proxy proxy = new Proxy().setHttpProxy("localhost:" + portForJSCoverProxy);
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("proxy", (Object)proxy);
        caps.setJavascriptEnabled(true);
        caps.setBrowserName("htmlunit");
        return new HtmlUnitDriver((Capabilities)caps);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests || this.mvnTestSkip) {
            this.getLog().info((CharSequence)"Skipping jscover-proxy-maven");
            return;
        }
        int portForJSCoverProxy = 3129;
        try (ServerSocket s2 = new ServerSocket(0);){
            s2.setReuseAddress(true);
            portForJSCoverProxy = s2.getLocalPort();
        }
        catch (IOException s2) {
            // empty catch block
        }
        ConfigurationForServer config = this.getConfigurationForServer(portForJSCoverProxy);
        config.validate();
        if (config.isInvalid()) {
            throw new MojoExecutionException("Invalid configuration");
        }
        this.getLog().info((CharSequence)("Output dir for report is " + this.outputDir.getAbsolutePath()));
        this.getLog().info((CharSequence)("Url for tests is " + this.baseUrl));
        jscover.Main main = new jscover.Main();
        main.initialize();
        Thread server = new Thread(() -> main.runServer(config));
        this.getLog().info((CharSequence)"Started JSCover proxy server");
        server.start();
        HtmlUnitDriver webClient = this.getWebClient(portForJSCoverProxy);
        this.getLog().info((CharSequence)("WebDriver is going to url: " + this.baseUrl));
        webClient.get(this.baseUrl);
        ExpectedCondition condition = ExpectedConditions.textToBePresentInElementLocated((By)By.cssSelector((String)this.cssSelectorForEndTest), (String)this.textForEndTest);
        new WebDriverWait((WebDriver)webClient, (long)this.timeout).until(webDriver -> (Boolean)condition.apply(webDriver));
        this.getLog().info((CharSequence)"Test ended, generating report");
        String res = (String)((JavascriptExecutor)webClient).executeAsyncScript("var callback = arguments[arguments.length - 1];callback(jscoverage_serializeCoverageToJSON());", new Object[0]);
        this.getLog().info((CharSequence)"Coverage extracted, submitting to JSCover");
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String reportNameEncoded = new String(URLCodec.encodeUrl(null, (byte[])this.reportName.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        HttpPost request = new HttpPost("http://localhost:" + portForJSCoverProxy + "/jscoverage-store/" + reportNameEncoded);
        request.addHeader("content-type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(res, StandardCharsets.UTF_8));
        try {
            httpClient.execute((HttpUriRequest)request);
            this.getLog().info((CharSequence)"Coverage Submitted to JSCover");
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to store the coverage", (Exception)e);
        }
        finally {
            webClient.close();
            webClient.quit();
            main.stop();
            String reportPath = new File(this.outputDir, this.reportName).getAbsolutePath();
            if (this.generateXMLSUMMARY) {
                this.generate("XMLSUMMARY", reportPath, false);
            }
            if (this.generateLCOV) {
                this.generate("LCOV", reportPath, true);
            }
            if (this.generateCOBERTURAXML) {
                this.generate("COBERTURAXML", reportPath, true);
            }
            this.getLog().info((CharSequence)"Finished JSCoverProxy");
        }
    }

    private void generate(String type, String reportPath, boolean jsSrcDirCheck) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Generating " + type));
        if (jsSrcDirCheck && this.jsSrcDir == null) {
            this.getLog().error((CharSequence)("jsSrcDir is mandatory when generating " + type + " report"));
            throw new MojoExecutionException("jsSrcDir is mandatory when generating " + type + " report");
        }
        try {
            ArrayList<String> params = new ArrayList<String>(Arrays.asList("--format=" + type, reportPath));
            if (jsSrcDirCheck) {
                params.add(this.jsSrcDir.getCanonicalPath());
            }
            Main.main((String[])params.toArray(new String[0]));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while generating " + type, (Exception)e);
        }
        this.getLog().info((CharSequence)(type + " generated"));
    }

    protected void setCommonConfiguration(ConfigurationCommon config) throws MojoExecutionException {
        config.setIncludeBranch(true);
        config.setIncludeFunction(true);
        config.setLocalStorage(true);
        config.setIncludeUnloadedJS(this.includeUnloadedJS);
        config.setECMAVersion(this.ecmaVersion);
        config.setDetectCoalesce(this.detectCoalesce);
        for (String instrumentArg : this.instrumentPathArgs) {
            if (instrumentArg.startsWith("--no-instrument=")) {
                config.addNoInstrument(instrumentArg);
                continue;
            }
            if (instrumentArg.startsWith("--no-instrument-reg=")) {
                config.addNoInstrumentReg(instrumentArg);
                continue;
            }
            if (instrumentArg.startsWith("--only-instrument-reg=")) {
                config.addOnlyInstrumentReg(instrumentArg);
                continue;
            }
            throw new MojoExecutionException(String.format("Invalid instrument path option '%s'", instrumentArg));
        }
        for (String noInstrument : this.noInstruments) {
            config.addNoInstrument("--no-instrument=" + noInstrument);
        }
    }

    private ConfigurationForServer getConfigurationForServer(int port) throws MojoExecutionException {
        ConfigurationForServer config = new ConfigurationForServer();
        this.setCommonConfiguration((ConfigurationCommon)config);
        if (this.jsSrcDir != null) {
            config.setDocumentRoot(this.jsSrcDir);
        }
        config.setPort(Integer.valueOf(port));
        config.setProxy(true);
        config.setReportDir(this.outputDir.getAbsoluteFile());
        return config;
    }
}

