/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jscoverproxy;

import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jscover.report.Main;
import jscover.server.ConfigurationForServer;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

@Mojo(name="coverage", defaultPhase=LifecyclePhase.VERIFY)
public class JSCoverProxyMavenMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String baseUrl;
    @Parameter(defaultValue="coverage")
    private String reportName;
    @Parameter(required=true)
    private File outputDir;
    @Parameter
    private String cssSelectorForEndTest = ".jasmine-duration";
    @Parameter
    private String textForEndTest = "finished";
    @Parameter
    private String jsSrcDir;
    @Parameter
    private boolean generateXMLSUMMARY;
    @Parameter
    private boolean generateLCOV;
    @Parameter
    private boolean generateCOBERTURAXML;
    @Parameter
    private List<String> noInstruments;

    private HtmlUnitDriver getWebClient(int portForJSCoverProxy) {
        Proxy proxy = new Proxy().setHttpProxy("localhost:" + portForJSCoverProxy);
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("proxy", (Object)proxy);
        caps.setJavascriptEnabled(true);
        return new HtmlUnitDriver((Capabilities)caps);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        int portForJSCoverProxy = 3129;
        try (ServerSocket s22 = new ServerSocket(0);){
            s22.setReuseAddress(true);
            portForJSCoverProxy = s22.getLocalPort();
        }
        catch (IOException s22) {
            // empty catch block
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("-ws", "--port=" + portForJSCoverProxy, "--proxy", "--local-storage", "--report-dir=" + this.outputDir.getAbsolutePath()));
        if (this.noInstruments != null && !this.noInstruments.isEmpty()) {
            args.addAll(this.noInstruments.stream().map(s -> "--no-instrument=" + s).collect(Collectors.toList()));
        }
        this.getLog().info((CharSequence)("Output dir for report is " + this.outputDir.getAbsolutePath()));
        this.getLog().info((CharSequence)("Url for tests is " + this.baseUrl));
        jscover.Main main = new jscover.Main();
        main.initialize();
        Thread server = new Thread(() -> main.runServer(ConfigurationForServer.parse((String[])args.toArray(new String[0]))));
        this.getLog().info((CharSequence)"Started JSCover proxy server");
        server.start();
        HtmlUnitDriver webClient = this.getWebClient(portForJSCoverProxy);
        this.getLog().info((CharSequence)("WebDriver is going to url: " + this.baseUrl));
        webClient.get(this.baseUrl);
        new WebDriverWait((WebDriver)webClient, 20L).until((Function)ExpectedConditions.textToBePresentInElementLocated((By)By.cssSelector((String)this.cssSelectorForEndTest), (String)this.textForEndTest));
        this.getLog().info((CharSequence)"Test ended, generating report");
        String res = (String)((JavascriptExecutor)webClient).executeAsyncScript("var callback = arguments[arguments.length - 1];callback(jscoverage_serializeCoverageToJSON());", new Object[0]);
        this.getLog().info((CharSequence)"Coverage extracted, submitting to JSCover");
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String reportNameEncoded = new String(URLCodec.encodeUrl(null, (byte[])this.reportName.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        HttpPost request = new HttpPost("http://localhost:" + portForJSCoverProxy + "/jscoverage-store/" + reportNameEncoded);
        request.addHeader("content-type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(res, StandardCharsets.UTF_8));
        try {
            httpClient.execute((HttpUriRequest)request);
            this.getLog().info((CharSequence)"Coverage Submitted to JSCover");
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("failed to store the coverage", (Exception)e);
            }
            catch (Throwable throwable) {
                webClient.close();
                webClient.quit();
                main.stop();
                String reportPath = new File(this.outputDir, this.reportName).getAbsolutePath();
                if (this.generateXMLSUMMARY) {
                    this.getLog().info((CharSequence)"Generating XMLSUMMARY");
                    try {
                        Main.main((String[])new String[]{"--format=XMLSUMMARY", reportPath});
                    }
                    catch (IOException e2) {
                        throw new MojoExecutionException("Error while generating XMLSUMMARY", (Exception)e2);
                    }
                    this.getLog().info((CharSequence)"XMLSUMMARY generated");
                }
                if (this.generateLCOV) {
                    this.getLog().info((CharSequence)"Generating LCOV");
                    if (this.jsSrcDir == null) {
                        this.getLog().error((CharSequence)"jsSrcDir is mandatory when generating LCOV report");
                        throw new MojoExecutionException("jsSrcDir is mandatory when generating LCOV report");
                    }
                    try {
                        Main.main((String[])new String[]{"--format=LCOV", reportPath, this.jsSrcDir});
                    }
                    catch (IOException e3) {
                        throw new MojoExecutionException("Error while generating LCOV", (Exception)e3);
                    }
                    this.getLog().info((CharSequence)"LCOV generated");
                }
                if (this.generateCOBERTURAXML) {
                    this.getLog().info((CharSequence)"Generating COBERTURAXML");
                    if (this.jsSrcDir == null) {
                        this.getLog().error((CharSequence)"jsSrcDir is mandatory when generating COBERTURAXML report");
                        throw new MojoExecutionException("jsSrcDir is mandatory when generating COBERTURAXML report");
                    }
                    try {
                        Main.main((String[])new String[]{"--format=COBERTURAXML", reportPath, this.jsSrcDir});
                    }
                    catch (IOException e4) {
                        throw new MojoExecutionException("Error while generating COBERTURAXML", (Exception)e4);
                    }
                    this.getLog().info((CharSequence)"COBERTURAXML generated");
                }
                this.getLog().info((CharSequence)"Finished JSCoverProxy");
                throw throwable;
            }
        }
        webClient.close();
        webClient.quit();
        main.stop();
        String reportPath = new File(this.outputDir, this.reportName).getAbsolutePath();
        if (this.generateXMLSUMMARY) {
            this.getLog().info((CharSequence)"Generating XMLSUMMARY");
            try {
                Main.main((String[])new String[]{"--format=XMLSUMMARY", reportPath});
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while generating XMLSUMMARY", (Exception)e);
            }
            this.getLog().info((CharSequence)"XMLSUMMARY generated");
        }
        if (this.generateLCOV) {
            this.getLog().info((CharSequence)"Generating LCOV");
            if (this.jsSrcDir == null) {
                this.getLog().error((CharSequence)"jsSrcDir is mandatory when generating LCOV report");
                throw new MojoExecutionException("jsSrcDir is mandatory when generating LCOV report");
            }
            try {
                Main.main((String[])new String[]{"--format=LCOV", reportPath, this.jsSrcDir});
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while generating LCOV", (Exception)e);
            }
            this.getLog().info((CharSequence)"LCOV generated");
        }
        if (this.generateCOBERTURAXML) {
            this.getLog().info((CharSequence)"Generating COBERTURAXML");
            if (this.jsSrcDir == null) {
                this.getLog().error((CharSequence)"jsSrcDir is mandatory when generating COBERTURAXML report");
                throw new MojoExecutionException("jsSrcDir is mandatory when generating COBERTURAXML report");
            }
            try {
                Main.main((String[])new String[]{"--format=COBERTURAXML", reportPath, this.jsSrcDir});
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while generating COBERTURAXML", (Exception)e);
            }
            this.getLog().info((CharSequence)"COBERTURAXML generated");
        }
        this.getLog().info((CharSequence)"Finished JSCoverProxy");
    }
}

