/*
 * Decompiled with CFR 0.152.
 */
package ch.datascience.service.security;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class PublicKeyReader$ {
    public static PublicKeyReader$ MODULE$;

    static {
        new PublicKeyReader$();
    }

    public Future<RSAPublicKey> getRSAPublicKey(Configuration config, WSClient ws, ExecutionContext ec) {
        Future future;
        Option option = config.getOptional("public-key", ConfigLoader$.MODULE$.stringLoader());
        if (option instanceof Some) {
            Some some = (Some)option;
            String encodedKey = (String)some.value();
            future = Future$.MODULE$.successful((Object)this.readRSAPublicKey(encodedKey));
        } else if (None$.MODULE$.equals(option)) {
            boolean strict = BoxesRunTime.unboxToBoolean((Object)config.getOptional("strict", ConfigLoader$.MODULE$.booleanLoader()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
            Option provider = config.getOptional("public-key-provider", ConfigLoader$.MODULE$.configurationLoader());
            future = strict ? Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Bad config: strict mode but no key given")) : (provider.nonEmpty() && ((Configuration)provider.get()).getOptional("type", ConfigLoader$.MODULE$.stringLoader()).contains((Object)"url") && ((Configuration)provider.get()).getOptional("url", ConfigLoader$.MODULE$.stringLoader()).nonEmpty() ? this.fetchRSAPublicKey((String)((Configuration)provider.get()).get("url", ConfigLoader$.MODULE$.stringLoader()), ws, ec) : Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Bad config: no key or provider")));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public Future<RSAPublicKey> getRSAPublicKey(Config config, WSClient ws, ExecutionContext ec) {
        return this.getRSAPublicKey(new Configuration(config), ws, ec);
    }

    public RSAPublicKey readRSAPublicKey(String encodedKey) {
        byte[] decoded = Base64.getDecoder().decode(encodedKey);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(decoded);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PublicKey key = factory.generatePublic(spec);
        return (RSAPublicKey)key;
    }

    public Future<RSAPublicKey> fetchRSAPublicKey(String url, WSClient ws, ExecutionContext ec) {
        return ws.url(url).get().map((Function1 & Serializable & scala.Serializable)response -> {
            String encodedKey = (String)JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup(response.json()), "public_key").as((Reads)Reads$.MODULE$.StringReads());
            return MODULE$.readRSAPublicKey(encodedKey);
        }, ec);
    }

    private PublicKeyReader$() {
        MODULE$ = this;
    }
}

