/*
 * Copyright 2017 - Swiss Data Science Center (SDSC)
 * A partnership between École Polytechnique Fédérale de Lausanne (EPFL) and
 * Eidgenössische Technische Hochschule Zürich (ETHZ).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.datascience.test.utils.persistence.graph

import javax.inject.{ Inject, Singleton }

import ch.datascience.service.utils.persistence.graph.{ JanusGraphConfigProvider, JanusGraphProvider }
import org.janusgraph.core.{ JanusGraph, JanusGraphFactory }
import play.api.inject.ApplicationLifecycle

@Singleton
class MockJanusGraphProvider @Inject() (
    override protected val config:    JanusGraphConfigProvider,
    override protected val lifecycle: ApplicationLifecycle
) extends JanusGraphProvider( config, lifecycle ) {

  override lazy val graph: JanusGraph = JanusGraphFactory.build().set( "storage.backend", "inmemory" ).open()

}
