/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.tests.performance.benchmark;

import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.PageSize;
import ch.codeblock.qrinvoice.QrInvoiceCodeCreator;
import ch.codeblock.qrinvoice.QrInvoicePaymentPartReceiptCreator;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.SwissPaymentsCode;
import ch.codeblock.qrinvoice.model.mapper.SwissPaymentsCodeToModelMapper;
import ch.codeblock.qrinvoice.model.parser.SwissPaymentsCodeParser;
import ch.codeblock.qrinvoice.output.PaymentPartReceipt;
import ch.codeblock.qrinvoice.output.QrCode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class Main {
    public static void main(String[] args) throws IOException {
        int warmUp = Integer.valueOf(Main.getProperty("warmUpRuns", "300"));
        int runs = Integer.valueOf(Main.getProperty("runs", "1000"));
        OutputFormat outputFormat = OutputFormat.valueOf((String)Main.getProperty("outputFormat", "PDF"));
        PageSize pageSize = PageSize.valueOf((String)Main.getProperty("pageSize", "A4"));
        Locale locale = new Locale(Main.getProperty("locale", "de"));
        String output = Main.getProperty("output", "PaymentPartReceipt");
        String formattedString = String.format("warmUpRuns=%s runs=%s output=%s outputFormat=%s pageSize=%s locale=%s", warmUp, runs, output, outputFormat, pageSize, locale);
        System.out.println(formattedString);
        System.out.println();
        int totalRuns = runs + warmUp;
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < totalRuns; ++i) {
            long start = System.currentTimeMillis();
            Main.generate(output, outputFormat, pageSize, locale);
            long end = System.currentTimeMillis();
            long ms = end - start;
            if (i < warmUp) continue;
            stats.addValue((double)ms);
            System.out.print(ms + "ms ");
        }
        System.out.println();
        System.out.println(formattedString);
        System.out.println("Statistics");
        System.out.println("- Min: " + Math.round(stats.getMin()));
        System.out.println("- Max: " + Math.round(stats.getMax()));
        System.out.println("- Mean / Avg: " + Math.round(stats.getMean()));
        System.out.println("- 50th percentile (Median): " + Math.round(stats.getPercentile(50.0)));
        System.out.println("- 75th percentile: " + Math.round(stats.getPercentile(75.0)));
        System.out.println("- 90th percentile: " + Math.round(stats.getPercentile(90.0)));
    }

    public static void generate(String output, OutputFormat outputFormat, PageSize pageSize, Locale locale) throws IOException {
        SwissPaymentsCode original = SwissPaymentsCodeParser.create().parse(IOUtils.toString((InputStream)Main.class.getResourceAsStream("/spc_IG2.0_page39_orig_qrr_qriban_avs_billinformation.txt"), (String)StandardCharsets.UTF_8.toString()));
        QrInvoice qrInvoice = SwissPaymentsCodeToModelMapper.create().map(original);
        if ("PaymentPartReceipt".equals(output)) {
            PaymentPartReceipt paymentPartReceipt = QrInvoicePaymentPartReceiptCreator.create().qrInvoice(qrInvoice).outputFormat(outputFormat).pageSize(pageSize).locale(locale).createPaymentPartReceipt();
        } else if ("QrCode".equals(output)) {
            QrCode qrCode = QrInvoiceCodeCreator.create().qrInvoice(qrInvoice).outputFormat(outputFormat).createQrCode();
        } else {
            throw new RuntimeException("Unsupported output: Valid are QrCode / PaymentPartReceipt");
        }
    }

    private static String getProperty(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        return defaultValue;
    }
}

