/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.tools.generator;

import ch.codeblock.qrinvoice.FontFamily;
import ch.codeblock.qrinvoice.PageSize;
import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.model.AlternativeSchemes;
import ch.codeblock.qrinvoice.model.Creditor;
import ch.codeblock.qrinvoice.model.CreditorInformation;
import ch.codeblock.qrinvoice.model.Header;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.ReferenceType;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.UltimateDebtor;
import ch.codeblock.qrinvoice.model.annotation.Description;
import ch.codeblock.qrinvoice.model.annotation.Example;
import ch.codeblock.qrinvoice.model.annotation.Mandatory;
import ch.codeblock.qrinvoice.model.annotation.Size;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class RestModelGenerator {
    private static final String INDENT = "    ";
    private static final String REST_MODEL_PACKAGE = "ch.codeblock.qrinvoice.rest.model";
    private static final Map<String, String> REPLACEMENT_MAP = new HashMap<String, String>();
    private static Path packageDir;

    public static void main(String[] args) throws IOException {
        Path outputModule = Paths.get(args[0], new String[0]);
        if (!Files.exists(outputModule, new LinkOption[0])) {
            throw new RuntimeException("Output Module does not exist");
        }
        packageDir = Files.createDirectories(outputModule.resolve("src/main/java").resolve(REST_MODEL_PACKAGE.replace('.', '/')), new FileAttribute[0]);
        RestModelGenerator.generate(Currency.class);
        RestModelGenerator.generate(Locale.class);
        RestModelGenerator.generate(PageSize.class);
        RestModelGenerator.generate(FontFamily.class);
        RestModelGenerator.generate(AlternativeSchemes.class);
        RestModelGenerator.generate(Creditor.class);
        RestModelGenerator.generate(CreditorInformation.class);
        RestModelGenerator.generate(PaymentAmountInformation.class);
        RestModelGenerator.generate(PaymentReference.class);
        RestModelGenerator.generate(ReferenceType.class);
        RestModelGenerator.generate(QrInvoice.class);
        RestModelGenerator.generate(UltimateDebtor.class);
        RestModelGenerator.generate(UltimateCreditor.class);
    }

    public static void generate(Class<?> clazz) throws IOException {
        Path javaFile = packageDir.resolve(RestModelGenerator.transformType(clazz.getSimpleName(), null) + ".java");
        System.out.println(javaFile.toFile().getAbsolutePath());
        try (PrintWriter printWriter = new PrintWriter(new FileOutputStream(javaFile.toFile()));){
            if (clazz.isEnum()) {
                RestModelGenerator.enumeration(clazz, printWriter);
            } else if (clazz.equals(Currency.class)) {
                RestModelGenerator.currencyEnum(clazz, printWriter);
            } else if (clazz.equals(Locale.class)) {
                RestModelGenerator.localeEnum(clazz, printWriter);
            } else {
                RestModelGenerator.clazz(clazz, printWriter);
            }
        }
    }

    private static void currencyEnum(Class<?> clazz, PrintWriter printWriter) {
        Stream<String> valuesStream = QrInvoiceSpec.SUPPORTED_CURRENCIES.stream().map(Currency::getCurrencyCode);
        RestModelGenerator.enumeration(clazz, printWriter, valuesStream);
    }

    private static void localeEnum(Class<?> clazz, PrintWriter printWriter) {
        Stream<String> valuesStream = QrInvoiceSpec.SUPPORTED_LOCALES.stream().map(Locale::getLanguage);
        RestModelGenerator.enumeration(clazz, printWriter, valuesStream);
    }

    private static void enumeration(Class<?> clazz, PrintWriter printWriter, Stream<String> valuesStream) {
        printWriter.printf("package %s;\n", REST_MODEL_PACKAGE);
        printWriter.println();
        printWriter.printf("public enum %s {", RestModelGenerator.transformType(clazz.getSimpleName(), null));
        printWriter.print(valuesStream.map(v -> System.lineSeparator() + INDENT + v).collect(Collectors.joining(",")));
        printWriter.println(";");
        printWriter.println();
        printWriter.println("    @Override");
        printWriter.println("    @com.fasterxml.jackson.annotation.JsonValue");
        printWriter.println("    public String toString() {");
        printWriter.println("        return name();");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    @com.fasterxml.jackson.annotation.JsonCreator");
        printWriter.printf("    public static %s fromValue(String text) {\n", RestModelGenerator.transformType(clazz.getSimpleName(), null));
        printWriter.printf("        for (%s v : %s.values()) {\n", RestModelGenerator.transformType(clazz.getSimpleName(), null), RestModelGenerator.transformType(clazz.getSimpleName(), null));
        printWriter.println("            if (String.valueOf(v.name()).equals(text)) {");
        printWriter.println("                return v;");
        printWriter.println("            }");
        printWriter.println("        }");
        printWriter.println("        return null;");
        printWriter.println("    }");
        printWriter.println("}");
    }

    private static void enumeration(Class<?> clazz, PrintWriter printWriter) {
        printWriter.printf("package %s;\n", REST_MODEL_PACKAGE);
        printWriter.println();
        printWriter.printf("@javax.annotation.Generated(value = \"ch.codeblock.qrinvoice.tools.ch.codeblock.qrinvoice.tools.generator.RestModelGenerator\", date = \"%s\")\n", LocalDateTime.now().toString());
        String newEnumClassName = RestModelGenerator.transformType(clazz.getSimpleName(), clazz.getName());
        printWriter.println("public enum " + newEnumClassName + " {");
        for (int i = 0; i < clazz.getEnumConstants().length; ++i) {
            String enumValuePostfix;
            Object o = clazz.getEnumConstants()[i];
            String string = enumValuePostfix = i == clazz.getEnumConstants().length - 1 ? ";" : ",";
            if (o instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)o;
                printWriter.printf("    %s(\"%s\")%s\n", referenceType.name(), referenceType.getReferenceTypeCode(), enumValuePostfix);
                continue;
            }
            if (o instanceof Enum) {
                Enum e = (Enum)o;
                printWriter.printf("    %s(\"%s\")%s\n", e.name(), e.name(), enumValuePostfix);
                continue;
            }
            throw new RuntimeException();
        }
        printWriter.println();
        printWriter.println("    private final String code;");
        printWriter.println();
        printWriter.printf("    %s(final String code) {\n", newEnumClassName);
        printWriter.println("        this.code = code;");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public String getCode() {");
        printWriter.println("        return code;");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    @Override");
        printWriter.println("    @com.fasterxml.jackson.annotation.JsonValue");
        printWriter.println("    public String toString() {");
        printWriter.println("        return String.valueOf(code);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    @com.fasterxml.jackson.annotation.JsonCreator");
        printWriter.printf("    public static %s fromValue(String text) {\n", newEnumClassName);
        printWriter.printf("        for (%s b : %s.values()) {\n", newEnumClassName, newEnumClassName);
        printWriter.println("            if (String.valueOf(b.code).equals(text)) {");
        printWriter.println("                return b;");
        printWriter.println("            }");
        printWriter.println("        }");
        printWriter.println("        return null;");
        printWriter.println("    }");
        printWriter.println("}");
    }

    private static void clazz(Class<?> clazz, PrintWriter printWriter) {
        printWriter.printf("package %s;\n", REST_MODEL_PACKAGE);
        printWriter.println();
        printWriter.printf("@javax.annotation.Generated(value = \"ch.codeblock.qrinvoice.tools.ch.codeblock.qrinvoice.tools.generator.RestModelGenerator\", date = \"%s\")\n", LocalDateTime.now().toString());
        printWriter.println("public class " + clazz.getSimpleName() + " {");
        List filteredFieldsList = FieldUtils.getAllFieldsList(clazz).stream().filter(field -> !field.getType().equals(Header.class)).collect(Collectors.toList());
        for (Field field2 : filteredFieldsList) {
            printWriter.println();
            Class<?> type = field2.getType();
            String name = field2.getName();
            int modifiers = field2.getModifiers();
            Optional<Method> optionalGetter = RestModelGenerator.getGetter(clazz, field2);
            if (optionalGetter.isPresent()) {
                Method getterMethod = optionalGetter.get();
                boolean required = getterMethod.getAnnotation(Mandatory.class) != null;
                String example = RestModelGenerator.getGetterExampleString(getterMethod);
                String description = RestModelGenerator.getGetterDescription(getterMethod);
                Size sizeAnnotation = getterMethod.getAnnotation(Size.class);
                if (sizeAnnotation != null) {
                    printWriter.printf("    @javax.validation.constraints.Size(min = %s, max = %s)\n", sizeAnnotation.min(), sizeAnnotation.max());
                }
                if (required) {
                    printWriter.println("    @javax.validation.constraints.NotNull");
                }
                printWriter.printf("    @io.swagger.annotations.ApiModelProperty(required = %s, value = \"%s\", notes = \"%s\", example = \"%s\")\n", required, description, description, example);
            }
            printWriter.printf("    @com.fasterxml.jackson.annotation.JsonProperty(\"%s\")\n", field2.getName());
            String visibilityModifier = RestModelGenerator.getVisibilityModifierString(modifiers);
            printWriter.printf("    %s %s %s;\n", visibilityModifier, RestModelGenerator.transformType(type.getName(), name), name);
        }
        printWriter.println();
        for (Field field2 : filteredFieldsList) {
            Optional<Method> optionalGetter = RestModelGenerator.getGetter(clazz, field2);
            if (optionalGetter.isPresent()) {
                Method getterMethod = optionalGetter.get();
                printWriter.printf("    %s %s %s(%s) {\n", "public", RestModelGenerator.transformType(getterMethod.getReturnType().getName(), field2.getName()), getterMethod.getName(), "");
                printWriter.printf("        return this.%s;\n", field2.getName());
                printWriter.println("    }");
            }
            printWriter.println();
            String setter = "set" + StringUtils.capitalize((String)field2.getName());
            try {
                Method setterMethod = clazz.getDeclaredMethod(setter, field2.getType());
                StringBuilder params = new StringBuilder();
                boolean first = true;
                for (Parameter parameter : setterMethod.getParameters()) {
                    if (!first) {
                        params.append(", ");
                    }
                    params.append(RestModelGenerator.transformType(parameter.getType().getName(), field2.getName()));
                    params.append(" ");
                    params.append(field2.getName());
                    first = false;
                }
                printWriter.printf("    %s void %s(%s) {\n", "public", setterMethod.getName(), params.toString());
                printWriter.printf("        this.%s = %s;\n", field2.getName(), field2.getName());
                printWriter.println("    }");
            }
            catch (NoSuchMethodException e) {
                System.err.println(e.getMessage());
            }
            printWriter.println();
        }
        printWriter.println("}");
    }

    private static String getGetterExampleString(Method getterMethod) {
        Example exampleAnnotation = getterMethod.getAnnotation(Example.class);
        return exampleAnnotation != null ? exampleAnnotation.value() : "";
    }

    private static String getGetterDescription(Method getterMethod) {
        Description descriptionAnnotation = getterMethod.getAnnotation(Description.class);
        String rawDescription = descriptionAnnotation != null ? descriptionAnnotation.value() : "";
        return rawDescription.replaceAll("\"", "\\\\\"");
    }

    private static String getVisibilityModifierString(int modifiers) {
        String visibilityModifier = Modifier.isPrivate(modifiers) ? "private" : (Modifier.isProtected(modifiers) ? "protected" : (Modifier.isPublic(modifiers) ? "public" : ""));
        return visibilityModifier;
    }

    private static Optional<Method> getGetter(Class<?> clazz, Field field) {
        String getter = "get" + StringUtils.capitalize((String)field.getName());
        return Stream.of(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(getter)).findFirst();
    }

    private static String transformType(String type, String fieldName) {
        return RestModelGenerator.transformTypeNames(RestModelGenerator.replaceType(type, fieldName));
    }

    private static String transformTypeNames(String type) {
        for (Map.Entry<String, String> entry : REPLACEMENT_MAP.entrySet()) {
            type = type.replace(entry.getKey(), entry.getValue());
        }
        return type;
    }

    private static String replaceType(String type, String fieldName) {
        if ("alternativeSchemeParameters".equalsIgnoreCase(fieldName) && List.class.getName().equals(type)) {
            return "String[]";
        }
        return type;
    }

    static {
        REPLACEMENT_MAP.put("ch.codeblock.qrinvoice.model", REST_MODEL_PACKAGE);
        REPLACEMENT_MAP.put("java.util.", "ch.codeblock.qrinvoice.rest.model.");
        REPLACEMENT_MAP.put(PageSize.class.getName(), "ch.codeblock.qrinvoice.rest.model." + PageSize.class.getSimpleName());
        REPLACEMENT_MAP.put("ReferenceType", "ReferenceTypeEnum");
        REPLACEMENT_MAP.put("Currency", "CurrencyEnum");
        REPLACEMENT_MAP.put("PageSize", "PageSizeEnum");
        REPLACEMENT_MAP.put("FontFamily", "FontFamilyEnum");
        REPLACEMENT_MAP.put("Locale", "LanguageEnum");
    }
}

