/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.infrastructure;

import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.infrastructure.IOutputWriterFactory;
import ch.codeblock.qrinvoice.paymentpartreceipt.IPaymentPartReceiptWriter;
import ch.codeblock.qrinvoice.paymentpartreceipt.IText4PaymentPartReceiptWriter;
import ch.codeblock.qrinvoice.paymentpartreceipt.PaymentPartReceiptWriterOptions;
import ch.codeblock.qrinvoice.qrcode.IQrCodeWriter;
import ch.codeblock.qrinvoice.qrcode.IText4QrCodeWriter;
import ch.codeblock.qrinvoice.qrcode.QrCodeWriterOptions;

public class IText4OutputWriterFactory
implements IOutputWriterFactory {
    public boolean supports(Object options) {
        if (options instanceof PaymentPartReceiptWriterOptions) {
            return this.supports((PaymentPartReceiptWriterOptions)options);
        }
        if (options instanceof QrCodeWriterOptions) {
            return this.supports((QrCodeWriterOptions)options);
        }
        return false;
    }

    public boolean supports(PaymentPartReceiptWriterOptions options) {
        return options.getOutputFormat().equals((Object)OutputFormat.PDF);
    }

    public IPaymentPartReceiptWriter create(PaymentPartReceiptWriterOptions options) {
        return new IText4PaymentPartReceiptWriter(options);
    }

    public boolean supports(QrCodeWriterOptions options) {
        return options.getOutputFormat().equals((Object)OutputFormat.PDF);
    }

    public IQrCodeWriter create(QrCodeWriterOptions options) {
        return new IText4QrCodeWriter(options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getShortName() {
        return this.getClass().getSimpleName().replace("PaymentPartWriterFactory", "");
    }
}

