/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.paymentpartreceipt;

import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.PageSize;
import ch.codeblock.qrinvoice.TechnicalException;
import ch.codeblock.qrinvoice.fonts.FontStyle;
import ch.codeblock.qrinvoice.graphics.Scissor;
import ch.codeblock.qrinvoice.layout.LayoutException;
import ch.codeblock.qrinvoice.layout.Point;
import ch.codeblock.qrinvoice.layout.Rect;
import ch.codeblock.qrinvoice.model.Address;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.ReferenceType;
import ch.codeblock.qrinvoice.model.UltimateCreditor;
import ch.codeblock.qrinvoice.model.util.AddressUtils;
import ch.codeblock.qrinvoice.model.util.AlternativeSchemesUtils;
import ch.codeblock.qrinvoice.output.PaymentPartReceipt;
import ch.codeblock.qrinvoice.paymentpartreceipt.AbstractItextPaymentPartReceiptWriter;
import ch.codeblock.qrinvoice.paymentpartreceipt.IPaymentPartReceiptWriter;
import ch.codeblock.qrinvoice.paymentpartreceipt.PaymentPartReceiptLayout;
import ch.codeblock.qrinvoice.paymentpartreceipt.PaymentPartReceiptWriterOptions;
import ch.codeblock.qrinvoice.qrcode.SwissQrCode;
import ch.codeblock.qrinvoice.util.CollectionUtils;
import ch.codeblock.qrinvoice.util.DecimalFormatFactory;
import ch.codeblock.qrinvoice.util.IbanUtils;
import ch.codeblock.qrinvoice.util.ReferenceUtils;
import ch.codeblock.qrinvoice.util.StringUtils;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.RectangleReadOnly;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IText4PaymentPartReceiptWriter
extends AbstractItextPaymentPartReceiptWriter
implements IPaymentPartReceiptWriter {
    private final Logger logger = LoggerFactory.getLogger(IText4PaymentPartReceiptWriter.class);
    private final Rectangle pageCanvas;
    private final Point<Float> rootLowerLeft;
    private final Point<Float> paymentPartLowerLeft;
    private final Rectangle receiptTitleSectionRect;
    private final Rectangle receiptInformationSectionRect;
    private final Rectangle receiptAmountSectionRect;
    private final Rectangle receiptAcceptanceSectionRect;
    private final Rectangle paymentPartTitleSectionRect;
    private final Rectangle paymentPartQrSectionRect;
    private final Rectangle paymentPartAmountSectionRect;
    private final Rectangle paymentPartInformationSectionRect;
    private final Rectangle paymentPartFurtherInfoSectionRect;
    private BaseFont regularFont;
    private BaseFont boldFont;
    private Font separationLabelFont;
    private Font receiptHeadingFont;
    private Font receiptValueFont;
    private Font paymentPartHeadingFont;
    private Font paymentPartValueFont;
    private static final SplitOnAllCharacters SPLIT_ON_ALL_CHARACTERS = new SplitOnAllCharacters();

    public IText4PaymentPartReceiptWriter(PaymentPartReceiptWriterOptions options) {
        super(options);
        switch (options.getPageSize()) {
            case A4: {
                this.pageCanvas = com.lowagie.text.PageSize.A4;
                break;
            }
            case A5: {
                this.pageCanvas = com.lowagie.text.PageSize.A5.rotate();
                break;
            }
            default: {
                this.pageCanvas = new RectangleReadOnly(((Float)DIN_LANG.getWidth()).floatValue(), ((Float)DIN_LANG.getHeight()).floatValue());
            }
        }
        this.rootLowerLeft = new Point((Number)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f));
        this.paymentPartLowerLeft = new Point((Number)Float.valueOf(this.pageCanvas.getWidth() - IText4PaymentPartReceiptWriter.getPaymentPartWidth()), (Number)Float.valueOf(0.0f));
        this.receiptTitleSectionRect = this.itextRectangle((Rect<Float>)RECEIPT_TITLE_SECTION_RECT.move(this.rootLowerLeft));
        this.receiptInformationSectionRect = this.itextRectangle((Rect<Float>)RECEIPT_INFORMATION_SECTION_RECT.move(this.rootLowerLeft));
        this.receiptAmountSectionRect = this.itextRectangle((Rect<Float>)RECEIPT_AMOUNT_SECTION_RECT.move(this.rootLowerLeft));
        this.receiptAcceptanceSectionRect = this.itextRectangle((Rect<Float>)RECEIPT_ACCEPTANCE_SECTION_RECT.move(this.rootLowerLeft));
        this.paymentPartTitleSectionRect = this.itextRectangle((Rect<Float>)PAYMENT_PART_TITLE_SECTION_RECT.move(this.paymentPartLowerLeft));
        this.paymentPartQrSectionRect = this.itextRectangle((Rect<Float>)PAYMENT_PART_QR_SECTION_RECT.move(this.paymentPartLowerLeft));
        this.paymentPartAmountSectionRect = this.itextRectangle((Rect<Float>)PAYMENT_PART_AMOUNT_SECTION_RECT.move(this.paymentPartLowerLeft));
        this.paymentPartInformationSectionRect = this.itextRectangle((Rect<Float>)PAYMENT_PART_INFORMATION_SECTION_RECT.move(this.paymentPartLowerLeft));
        this.paymentPartFurtherInfoSectionRect = this.itextRectangle((Rect<Float>)PAYMENT_PART_FURTHER_INFO_SECTION_RECT.move(this.paymentPartLowerLeft));
        try {
            this.boldFont = BaseFont.createFont((String)this.getFontNameOrFontPath(options.getFontFamily(), FontStyle.BOLD), (String)PDF_ENCODING, (boolean)true);
            this.regularFont = BaseFont.createFont((String)this.getFontNameOrFontPath(options.getFontFamily(), FontStyle.PLAIN), (String)PDF_ENCODING, (boolean)true);
            this.paymentPartHeadingFont = new Font(this.boldFont, 8.0f);
            this.paymentPartValueFont = new Font(this.regularFont, 10.0f);
            this.separationLabelFont = new Font(this.regularFont, 7.0f);
            this.receiptHeadingFont = new Font(this.boldFont, 6.0f);
            this.receiptValueFont = new Font(this.regularFont, 8.0f);
        }
        catch (Exception e) {
            throw new TechnicalException("Error while creating fonts", (Throwable)e);
        }
    }

    public PaymentPartReceipt write(QrInvoice qrInvoice, BufferedImage qrCodeImage) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(25600);
            Document document = new Document(this.pageCanvas, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            this.addReceiptTitleSection(writer);
            this.addReceiptInformationSection(writer, qrInvoice);
            this.addReceiptAmount(writer, qrInvoice.getPaymentAmountInformation());
            this.addReceiptAcceptanceSection(writer);
            this.addPaymentPartTitleSection(writer);
            this.addQrCodeImage(writer, qrCodeImage);
            this.addPaymentPartAmount(writer, qrInvoice.getPaymentAmountInformation());
            this.addPaymentPartInformationSection(writer, qrInvoice);
            this.addPaymentPartFurtherInfoSection(writer, qrInvoice);
            this.drawBoundaryLines(writer.getDirectContent());
            document.close();
            return new PaymentPartReceipt(this.getOptions().getPageSize(), OutputFormat.PDF, baos.toByteArray(), null, null);
        }
        catch (DocumentException | IOException e) {
            throw new TechnicalException("Unexpected exception occurred during the creation of the payment part", e);
        }
    }

    private void addReceiptTitleSection(PdfWriter writer) {
        this.debugLayout(writer, this.receiptTitleSectionRect);
        PdfContentByte content = writer.getDirectContent();
        content.beginText();
        content.setFontAndSize(this.receiptHeadingFont.getBaseFont(), 11.0f);
        content.showTextAligned(0, this.getLabel("TitleReceipt"), this.receiptTitleSectionRect.getLeft(), this.receiptTitleSectionRect.getTop() - 11.0f, 0.0f);
        content.endText();
    }

    private void addReceiptInformationSection(PdfWriter writer, QrInvoice qrInvoice) throws DocumentException {
        this.debugLayout(writer, this.receiptInformationSectionRect);
        Float fixedLeading = (Float)FIXED_LEADINGS.get(this.getOptions().getLayout());
        Float multipliedLeading = (Float)MULTIPLIED_LEADINGS.get(this.getOptions().getLayout());
        PdfContentByte cb = writer.getDirectContent();
        ColumnText ct = new ColumnText(cb);
        float top = this.receiptInformationSectionRect.getTop() + fixedLeading.floatValue() + multipliedLeading.floatValue() * 6.0f - 6.0f;
        ct.setSimpleColumn(this.receiptInformationSectionRect.getLeft(), this.receiptInformationSectionRect.getBottom(), this.receiptInformationSectionRect.getRight(), top);
        ct.setLeading(fixedLeading.floatValue(), multipliedLeading.floatValue());
        boolean omitStreetNameHouseNumberOrAddressLine1 = this.getOptions().getLayout() != PaymentPartReceiptLayout.RELAXED;
        this.writeReceiptInformationSectionTitle(ct, this.getLabel("CdtrInf.IBANCreditor"), true, true);
        ct.addText(this.chunk(IbanUtils.formatIban((String)qrInvoice.getCreditorInformation().getIban()), true, this.receiptValueFont));
        AddressUtils.toAddressLines((Address)qrInvoice.getCreditorInformation().getCreditor(), (boolean)omitStreetNameHouseNumberOrAddressLine1).forEach(addressLine -> ct.addText(this.chunk((String)addressLine, true, this.receiptValueFont)));
        PaymentReference paymentReference = qrInvoice.getPaymentReference();
        if (paymentReference != null && paymentReference.getReferenceType() != null) {
            switch (paymentReference.getReferenceType()) {
                case QR_REFERENCE: 
                case CREDITOR_REFERENCE: {
                    this.writeReceiptInformationSectionTitle(ct, this.getLabel("RmtInf.Ref"), true, false);
                    ct.addText(this.chunk(ReferenceUtils.format((ReferenceType)paymentReference.getReferenceType(), (String)paymentReference.getReference()), true, this.receiptValueFont));
                    break;
                }
            }
        }
        if (AddressUtils.isEmpty((Address)qrInvoice.getUltimateDebtor())) {
            float lineHeight = fixedLeading.floatValue() + multipliedLeading.floatValue() * 8.0f;
            this.writeReceiptInformationSectionTitle(ct, this.getLabel("UltmtDbtr.Empty"), true, false);
            ct.go();
            float leftX = this.receiptInformationSectionRect.getLeft();
            float upperY = ct.getYLine() - lineHeight / 2.0f;
            float lowerY = upperY - ((Float)RECEIPT_DEBTOR_FIELD.getHeight()).floatValue();
            Rect debtorField = RECEIPT_DEBTOR_FIELD.toRectangle((Number)Float.valueOf(leftX), (Number)Float.valueOf(lowerY));
            this.writeFreeTextBox(ct.getCanvas(), (Rect<Float>)debtorField);
            ct.addText(new Chunk(this.neededLinesBreaks(((Float)debtorField.getHeight()).floatValue(), lineHeight), this.receiptValueFont));
        } else {
            this.writeReceiptInformationSectionTitle(ct, this.getLabel("UltmtDbtr"), true, false);
            Iterator addressLines = AddressUtils.toAddressLines((Address)qrInvoice.getUltimateDebtor(), (boolean)omitStreetNameHouseNumberOrAddressLine1).iterator();
            while (addressLines.hasNext()) {
                ct.addText(this.chunk((String)addressLines.next(), addressLines.hasNext(), this.receiptValueFont));
            }
        }
        int ret = ct.go(false);
        switch (ret) {
            case 1: {
                break;
            }
            case 2: {
                String message = "Not all content could be printed to the information section";
                if (System.getProperty("QrInvoice.IgnoreLayoutErrors") == null) {
                    throw new LayoutException("Not all content could be printed to the information section");
                }
                this.logger.info("Not all content could be printed to the information section");
                break;
            }
            default: {
                throw new IllegalStateException("Got unexpected result: " + ret);
            }
        }
    }

    private void writeReceiptInformationSectionTitle(ColumnText ct, String text, boolean newLine, boolean firstTitle) throws DocumentException {
        this.writeInformationSectionTitle(ct, text, newLine, firstTitle, this.receiptHeadingFont);
    }

    private void addReceiptAmount(PdfWriter writer, PaymentAmountInformation paymentAmountInformation) {
        this.debugLayout(writer, this.receiptAmountSectionRect);
        float lowerY = this.receiptAmountSectionRect.getBottom();
        float upperY = this.receiptAmountSectionRect.getTop();
        PdfContentByte canvas = writer.getDirectContent();
        canvas.setFontAndSize(this.receiptHeadingFont.getBaseFont(), 6.0f);
        canvas.beginText();
        float currencyX = ((Float)this.rootLowerLeft.getX()).floatValue() + QUIET_SPACE_PTS;
        float amountX = ((Float)this.rootLowerLeft.getX()).floatValue() + QUIET_SPACE_PTS + Utilities.millimetersToPoints((float)12.0f);
        float headerY = upperY - 6.0f;
        canvas.showTextAligned(0, this.getLabel("Currency"), currencyX, headerY, 0.0f);
        canvas.showTextAligned(0, this.getLabel("Amount"), amountX, headerY, 0.0f);
        canvas.endText();
        canvas.setFontAndSize(this.receiptValueFont.getBaseFont(), 8.0f);
        canvas.beginText();
        float valuesY = headerY - 8.0f - 5.0f;
        canvas.showTextAligned(0, paymentAmountInformation.getCurrency().getCurrencyCode(), currencyX, valuesY, 0.0f);
        if (paymentAmountInformation.getAmount() != null) {
            String formattedAmount = DecimalFormatFactory.createPrintAmountFormat().format(paymentAmountInformation.getAmount());
            canvas.showTextAligned(0, formattedAmount, amountX, valuesY, 0.0f);
        }
        canvas.endText();
        if (paymentAmountInformation.getAmount() == null) {
            Rect rect = RECEIPT_AMOUNT_FIELD.toRectangle((Number)Float.valueOf(this.receiptAmountSectionRect.getRight() - ((Float)RECEIPT_AMOUNT_FIELD.getWidth()).floatValue()), (Number)Float.valueOf(lowerY));
            this.writeFreeTextBox(canvas, (Rect<Float>)rect);
        }
    }

    private void addReceiptAcceptanceSection(PdfWriter writer) {
        this.debugLayout(writer, this.receiptAcceptanceSectionRect);
        PdfContentByte content = writer.getDirectContent();
        content.beginText();
        float x = this.receiptAcceptanceSectionRect.getRight();
        float y = this.receiptAcceptanceSectionRect.getTop() - 6.0f - Utilities.millimetersToPoints((float)2.0f);
        content.setFontAndSize(this.paymentPartHeadingFont.getBaseFont(), 6.0f);
        content.showTextAligned(2, this.getLabel("AcceptancePoint"), x, y, 0.0f);
        content.endText();
    }

    private void addPaymentPartTitleSection(PdfWriter writer) {
        this.debugLayout(writer, this.paymentPartTitleSectionRect);
        PdfContentByte content = writer.getDirectContent();
        content.beginText();
        content.setFontAndSize(this.paymentPartHeadingFont.getBaseFont(), 11.0f);
        content.showTextAligned(0, this.getLabel("TitlePaymentPart"), this.paymentPartTitleSectionRect.getLeft(), this.paymentPartTitleSectionRect.getTop() - 11.0f, 0.0f);
        content.endText();
    }

    private void addQrCodeImage(PdfWriter writer, BufferedImage qrCodeImage) throws IOException, DocumentException {
        this.debugLayout(writer, this.paymentPartQrSectionRect);
        float x = this.paymentPartQrSectionRect.getLeft();
        float y = this.paymentPartQrSectionRect.getBottom() + QUIET_SPACE_PTS;
        Image image = Image.getInstance((java.awt.Image)qrCodeImage, null, (boolean)true);
        image.setAbsolutePosition(x, y);
        float size = Utilities.millimetersToPoints((float)((Float)SwissQrCode.QR_CODE_SIZE.getWidth()).floatValue());
        image.scaleToFit(size, size);
        PdfContentByte canvas = writer.getDirectContent();
        canvas.addImage(image);
    }

    private void addPaymentPartInformationSection(PdfWriter writer, QrInvoice qrInvoice) throws DocumentException {
        this.debugLayout(writer, this.paymentPartInformationSectionRect);
        Float fixedLeading = (Float)FIXED_LEADINGS.get(this.getOptions().getLayout());
        Float multipliedLeading = (Float)MULTIPLIED_LEADINGS.get(this.getOptions().getLayout());
        PdfContentByte cb = writer.getDirectContent();
        ColumnText ct = new ColumnText(cb);
        float top = this.paymentPartInformationSectionRect.getTop() + fixedLeading.floatValue() + multipliedLeading.floatValue() * 8.0f - 8.0f;
        ct.setSimpleColumn(this.paymentPartInformationSectionRect.getLeft(), this.paymentPartInformationSectionRect.getBottom(), this.paymentPartInformationSectionRect.getRight(), top);
        ct.setLeading(fixedLeading.floatValue(), multipliedLeading.floatValue());
        this.writePaymentPartInformationSectionTitle(ct, this.getLabel("CdtrInf.IBANCreditor"), true, true);
        ct.addText(this.chunk(IbanUtils.formatIban((String)qrInvoice.getCreditorInformation().getIban()), true, this.paymentPartValueFont));
        AddressUtils.toAddressLines((Address)qrInvoice.getCreditorInformation().getCreditor()).forEach(addressLine -> ct.addText(this.chunk((String)addressLine, true, this.paymentPartValueFont)));
        PaymentReference paymentReference = qrInvoice.getPaymentReference();
        if (paymentReference != null) {
            if (paymentReference.getReferenceType() != null) {
                switch (paymentReference.getReferenceType()) {
                    case QR_REFERENCE: 
                    case CREDITOR_REFERENCE: {
                        this.writePaymentPartInformationSectionTitle(ct, this.getLabel("RmtInf.Ref"), true, false);
                        ct.addText(this.chunk(ReferenceUtils.format((ReferenceType)paymentReference.getReferenceType(), (String)paymentReference.getReference()), true, this.paymentPartValueFont));
                        break;
                    }
                }
            }
            String unstructuredMessage = paymentReference.getAdditionalInformation().getUnstructuredMessage();
            String billInformation = paymentReference.getAdditionalInformation().getBillInformation();
            if (unstructuredMessage != null || billInformation != null) {
                this.writePaymentPartInformationSectionTitle(ct, this.getLabel("RmtInf.AddInf.Ustrd"), true, false);
                if (this.getOptions().getLayout() == PaymentPartReceiptLayout.COMPRESSED && StringUtils.length((CharSequence[])new CharSequence[]{unstructuredMessage, billInformation}) > 80) {
                    String joined = StringUtils.join((CharSequence)" ", (CharSequence[])new CharSequence[]{unstructuredMessage, billInformation});
                    ct.addText(this.chunk(joined, true, this.paymentPartValueFont));
                } else {
                    if (unstructuredMessage != null) {
                        ct.addText(this.chunk(unstructuredMessage, true, this.paymentPartValueFont));
                    }
                    if (billInformation != null) {
                        ct.addText(this.chunk(billInformation, true, this.paymentPartValueFont));
                    }
                }
            }
        }
        if (AddressUtils.isEmpty((Address)qrInvoice.getUltimateDebtor())) {
            float lineHeight = fixedLeading.floatValue() + multipliedLeading.floatValue() * 10.0f;
            this.writePaymentPartInformationSectionTitle(ct, this.getLabel("UltmtDbtr.Empty"), true, false);
            ct.go();
            float leftX = this.paymentPartInformationSectionRect.getLeft();
            float upperY = ct.getYLine() - lineHeight / 2.0f;
            float lowerY = upperY - ((Float)PAYMENT_PART_DEBTOR_FIELD.getHeight()).floatValue();
            Rect debtorField = PAYMENT_PART_DEBTOR_FIELD.toRectangle((Number)Float.valueOf(leftX), (Number)Float.valueOf(lowerY));
            this.writeFreeTextBox(ct.getCanvas(), (Rect<Float>)debtorField);
            ct.addText(new Chunk(this.neededLinesBreaks(((Float)debtorField.getHeight()).floatValue(), lineHeight), this.paymentPartValueFont));
        } else {
            this.writePaymentPartInformationSectionTitle(ct, this.getLabel("UltmtDbtr"), true, false);
            Iterator addressLines = AddressUtils.toAddressLines((Address)qrInvoice.getUltimateDebtor()).iterator();
            while (addressLines.hasNext()) {
                ct.addText(this.chunk((String)addressLines.next(), addressLines.hasNext(), this.paymentPartValueFont));
            }
        }
        int ret = ct.go(false);
        switch (ret) {
            case 1: {
                break;
            }
            case 2: {
                String message = "Not all content could be printed to the information section";
                if (System.getProperty("QrInvoice.IgnoreLayoutErrors") == null) {
                    throw new LayoutException("Not all content could be printed to the information section");
                }
                this.logger.info("Not all content could be printed to the information section");
                break;
            }
            default: {
                throw new IllegalStateException("Got unexpected result: " + ret);
            }
        }
    }

    private void writePaymentPartInformationSectionTitle(ColumnText ct, String text, boolean newLine, boolean firstTitle) throws DocumentException {
        this.writeInformationSectionTitle(ct, text, newLine, firstTitle, this.paymentPartHeadingFont);
    }

    private void writeInformationSectionTitle(ColumnText ct, String text, boolean newLine, boolean firstTitle, Font font) throws DocumentException {
        Float fixedLeading = (Float)FIXED_LEADINGS.get(this.getOptions().getLayout());
        Float headingLeading = firstTitle ? Float.valueOf(0.0f) : (Float)HEADING_LEADINGS.get(this.getOptions().getLayout());
        Float multipliedLeading = (Float)MULTIPLIED_LEADINGS.get(this.getOptions().getLayout());
        ct.go();
        ct.setLeading(fixedLeading.floatValue() + headingLeading.floatValue(), multipliedLeading.floatValue());
        ct.addText(this.chunk(text, newLine, font));
        ct.go();
        ct.setLeading(fixedLeading.floatValue(), multipliedLeading.floatValue());
    }

    private void addPaymentPartAmount(PdfWriter writer, PaymentAmountInformation paymentAmountInformation) {
        this.debugLayout(writer, this.paymentPartAmountSectionRect);
        float lowerY = this.paymentPartAmountSectionRect.getBottom();
        float upperY = this.paymentPartAmountSectionRect.getTop();
        PdfContentByte canvas = writer.getDirectContent();
        canvas.setFontAndSize(this.paymentPartHeadingFont.getBaseFont(), 8.0f);
        canvas.beginText();
        float currencyX = ((Float)this.paymentPartLowerLeft.getX()).floatValue() + QUIET_SPACE_PTS;
        float amountX = ((Float)this.paymentPartLowerLeft.getX()).floatValue() + QUIET_SPACE_PTS + Utilities.millimetersToPoints((float)14.0f);
        float headerY = upperY - 8.0f;
        canvas.showTextAligned(0, this.getLabel("Currency"), currencyX, headerY, 0.0f);
        canvas.showTextAligned(0, this.getLabel("Amount"), amountX, headerY, 0.0f);
        canvas.endText();
        canvas.setFontAndSize(this.paymentPartValueFont.getBaseFont(), 10.0f);
        canvas.beginText();
        float valuesY = headerY - 10.0f - 5.0f;
        canvas.showTextAligned(0, paymentAmountInformation.getCurrency().getCurrencyCode(), currencyX, valuesY, 0.0f);
        if (paymentAmountInformation.getAmount() != null) {
            String formattedAmount = DecimalFormatFactory.createPrintAmountFormat().format(paymentAmountInformation.getAmount());
            canvas.showTextAligned(0, formattedAmount, amountX, valuesY, 0.0f);
        }
        canvas.endText();
        if (paymentAmountInformation.getAmount() == null) {
            Rect rect = PAYMENT_PART_AMOUNT_FIELD.toRectangle((Number)Float.valueOf(amountX), (Number)Float.valueOf(lowerY));
            this.writeFreeTextBox(canvas, (Rect<Float>)rect);
        }
    }

    private void addPaymentPartFurtherInfoSection(PdfWriter writer, QrInvoice qrInvoice) {
        UltimateCreditor ultimateCreditor;
        PdfContentByte canvas;
        this.debugLayout(writer, this.paymentPartFurtherInfoSectionRect);
        if (qrInvoice.getAlternativeSchemes() == null || CollectionUtils.isEmpty((Collection)qrInvoice.getAlternativeSchemes().getAlternativeSchemeParameters())) {
            return;
        }
        float x = this.paymentPartFurtherInfoSectionRect.getLeft();
        float y = this.paymentPartFurtherInfoSectionRect.getBottom() + Utilities.millimetersToPoints((float)0.5f);
        if (qrInvoice.getAlternativeSchemes().getAlternativeSchemeParameters() != null) {
            ArrayList alternativeSchemes = new ArrayList(qrInvoice.getAlternativeSchemes().getAlternativeSchemeParameters());
            Collections.reverse(alternativeSchemes);
            canvas = writer.getDirectContent();
            canvas.beginText();
            for (String alternativeScheme : alternativeSchemes) {
                AlternativeSchemesUtils.AlternativeSchemePair scheme = AlternativeSchemesUtils.parseForOutput((String)alternativeScheme);
                if (scheme.isEmpty()) continue;
                if (scheme.hasName()) {
                    canvas.setFontAndSize(this.paymentPartHeadingFont.getBaseFont(), 7.0f);
                    canvas.showTextAligned(0, scheme.getName(), x, y, 0.0f);
                    if (scheme.hasValue()) {
                        float widthName = this.paymentPartHeadingFont.getBaseFont().getWidthPoint(scheme.getName(), 7.0f);
                        float remainingSpaceValue = this.paymentPartFurtherInfoSectionRect.getWidth() - widthName;
                        String value = this.trimIfRequired(scheme.getValue(), remainingSpaceValue, this.paymentPartValueFont, 7);
                        canvas.setFontAndSize(this.paymentPartValueFont.getBaseFont(), 7.0f);
                        canvas.showText(value);
                    }
                } else {
                    String value = this.trimIfRequired(scheme.getValue(), this.paymentPartFurtherInfoSectionRect.getWidth(), this.paymentPartValueFont, 7);
                    canvas.setFontAndSize(this.paymentPartValueFont.getBaseFont(), 7.0f);
                    canvas.showTextAligned(0, value, x, y, 0.0f);
                }
                y += 7.0f + Utilities.millimetersToPoints((float)1.0f);
            }
            canvas.endText();
        }
        if (!AddressUtils.isEmpty((Address)(ultimateCreditor = qrInvoice.getUltimateCreditor()))) {
            canvas = writer.getDirectContent();
            canvas.beginText();
            String ultmtCdtrLabel = this.getLabel("UltmtCdtr") + " ";
            canvas.setFontAndSize(this.paymentPartHeadingFont.getBaseFont(), 7.0f);
            canvas.showTextAligned(0, ultmtCdtrLabel, x, y, 0.0f);
            float widthName = this.paymentPartHeadingFont.getBaseFont().getWidthPoint(ultmtCdtrLabel, 7.0f);
            float remainingWidthAddressLine = this.paymentPartFurtherInfoSectionRect.getWidth() - widthName;
            String addressLine = this.trimIfRequired(AddressUtils.toSingleLineAddress((Address)ultimateCreditor), remainingWidthAddressLine, this.paymentPartValueFont, 7);
            canvas.setFontAndSize(this.paymentPartValueFont.getBaseFont(), 7.0f);
            canvas.showText(addressLine);
            canvas.endText();
        }
    }

    private String trimIfRequired(String input, float maxWidth, Font font, int fontSize) {
        float widthPoint = font.getBaseFont().getWidthPoint(input, (float)fontSize);
        if (widthPoint <= maxWidth) {
            return input;
        }
        String newString = input;
        while (widthPoint > maxWidth) {
            int len = newString.length();
            float ratioTooWide = widthPoint / maxWidth;
            int newLen = Math.min((int)Math.floor((float)len / ratioTooWide), newString.length() - 1);
            newString = newString.substring(0, newLen);
            widthPoint = font.getBaseFont().getWidthPoint(newString + "...", (float)fontSize);
        }
        return newString + "...";
    }

    private void writeFreeTextBox(PdfContentByte canvas, Rect<Float> rect) {
        float cornerLength = BOX_CORNER_LINE_LENGTH;
        float leftX = ((Float)rect.getLowerLeftX()).floatValue();
        float lowerY = ((Float)rect.getLowerLeftY()).floatValue();
        float rightX = ((Float)rect.getUpperRightX()).floatValue();
        float upperY = ((Float)rect.getUpperRightY()).floatValue();
        canvas.setColorStroke(Color.BLACK);
        canvas.setLineWidth(BOX_CORNER_LINE_WIDTH);
        canvas.moveTo(leftX + cornerLength, lowerY);
        canvas.lineTo(leftX, lowerY);
        canvas.lineTo(leftX, lowerY + cornerLength);
        canvas.stroke();
        canvas.closePath();
        canvas.moveTo(leftX + cornerLength, upperY);
        canvas.lineTo(leftX, upperY);
        canvas.lineTo(leftX, upperY - cornerLength);
        canvas.stroke();
        canvas.closePath();
        canvas.moveTo(rightX - cornerLength, upperY);
        canvas.lineTo(rightX, upperY);
        canvas.lineTo(rightX, upperY - cornerLength);
        canvas.stroke();
        canvas.closePath();
        canvas.moveTo(rightX - cornerLength, lowerY);
        canvas.lineTo(rightX, lowerY);
        canvas.lineTo(rightX, lowerY + cornerLength);
        canvas.stroke();
        canvas.closePath();
    }

    private void drawBoundaryLines(PdfContentByte canvas) {
        if (this.getOptions().isBoundaryLines()) {
            this.writeSeparationLabel(canvas);
            this.drawVerticalBoundaryLine(canvas);
            this.drawHorizontalBoundaryLine(canvas);
        }
    }

    private void writeSeparationLabel(PdfContentByte canvas) {
        if (this.getOptions().isBoundaryLineSeparationText() && this.getOptions().getPageSize().greaterThan(PageSize.DIN_LANG)) {
            canvas.setFontAndSize(this.separationLabelFont.getBaseFont(), this.separationLabelFont.getSize());
            float y = ((Float)this.rootLowerLeft.getY()).floatValue() + IText4PaymentPartReceiptWriter.getPaymentPartHeight() + this.separationLabelFont.getBaseFont().getAscentPoint(this.getLabel("SeparationLabel"), this.separationLabelFont.getSize());
            float x = this.pageCanvas.getRight() - QUIET_SPACE_PTS;
            canvas.beginText();
            canvas.showTextAligned(2, this.getLabel("SeparationLabel"), x, y, 0.0f);
            canvas.endText();
        } else if (this.getOptions().isBoundaryLineSeparationText()) {
            this.logger.warn("Separation label above payment part was not printed as PageSize is too small.");
        }
    }

    private void drawVerticalBoundaryLine(PdfContentByte canvas) {
        float x = ((Float)this.paymentPartLowerLeft.getX()).floatValue();
        float lowerY = ((Float)this.paymentPartLowerLeft.getY()).floatValue();
        float upperY = lowerY + IText4PaymentPartReceiptWriter.getPaymentPartHeight();
        canvas.setColorStroke(Color.BLACK);
        canvas.setLineWidth(0.5f);
        if (this.getOptions().isBoundaryLineScissors()) {
            float scissorY = upperY - QUIET_SPACE_PTS;
            this.drawScissor(canvas, x, scissorY, true);
            canvas.moveTo(x, lowerY);
            canvas.lineTo(x, scissorY - Utilities.millimetersToPoints((float)5.0f));
            canvas.closePathStroke();
            canvas.moveTo(x, scissorY);
            canvas.lineTo(x, upperY);
            canvas.closePathStroke();
        } else {
            canvas.moveTo(x, lowerY);
            canvas.lineTo(x, upperY);
            canvas.closePathStroke();
        }
    }

    private void drawHorizontalBoundaryLine(PdfContentByte canvas) {
        boolean printHorizontalScissor;
        float leftX = ((Float)this.rootLowerLeft.getX()).floatValue();
        float lineY = ((Float)this.paymentPartLowerLeft.getY()).floatValue() + IText4PaymentPartReceiptWriter.getPaymentPartHeight();
        float rightX = leftX + ((Float)DIN_LANG.getWidth()).floatValue();
        canvas.setColorStroke(Color.BLACK);
        canvas.setLineWidth(0.5f);
        boolean bl = printHorizontalScissor = this.getOptions().isBoundaryLineScissors() && this.getOptions().getPageSize().greaterThan(PageSize.DIN_LANG);
        if (printHorizontalScissor) {
            float scissorX = leftX + QUIET_SPACE_PTS;
            this.drawScissor(canvas, scissorX, lineY, false);
            canvas.moveTo(leftX, lineY);
            canvas.lineTo(scissorX, lineY);
            canvas.closePathStroke();
            canvas.moveTo(scissorX + Utilities.millimetersToPoints((float)5.0f), lineY);
            canvas.lineTo(rightX, lineY);
            canvas.closePathStroke();
        } else {
            if (this.getOptions().isBoundaryLineScissors()) {
                this.logger.info("Scissor on horizontal line is only printed when using PageSize A4 or A5");
            }
            canvas.moveTo(leftX, lineY);
            canvas.lineTo(rightX, lineY);
            canvas.closePathStroke();
        }
    }

    private void drawScissor(PdfContentByte canvas, float x, float y, boolean rotate90degree) {
        float scissorWidth = Utilities.millimetersToPoints((float)5.0f);
        float scissorHeight = Utilities.millimetersToPoints((float)(5.0f * Scissor.getOrigHeight() / Scissor.getOrigWidth()));
        double scale = (double)scissorWidth / (double)Scissor.getOrigWidth();
        float scissorRotatedWidth = (rotate90degree ? scissorHeight : scissorWidth) + Utilities.millimetersToPoints((float)0.0f);
        float scissorRotatedHeight = (rotate90degree ? scissorWidth : scissorHeight) + Utilities.millimetersToPoints((float)0.0f);
        float scissorX = rotate90degree ? x - scissorRotatedWidth / 2.0f : x;
        float scissorY = rotate90degree ? y - scissorRotatedHeight : y - scissorRotatedHeight / 2.0f;
        PdfTemplate template = canvas.createTemplate(scissorRotatedWidth, scissorRotatedHeight);
        PdfGraphics2D g2d = new PdfGraphics2D((PdfContentByte)template, scissorRotatedWidth, scissorRotatedHeight);
        AffineTransform at = new AffineTransform();
        if (rotate90degree) {
            at.translate(scissorRotatedWidth, 0.0);
        }
        at.rotate(rotate90degree ? Math.toRadians(90.0) : 0.0);
        at.scale(scale, scale);
        g2d.setTransform(at);
        Scissor.paint((Graphics2D)g2d);
        g2d.dispose();
        canvas.addTemplate(template, scissorX, scissorY);
    }

    private void debugLayout(PdfWriter writer, Rectangle rectangle) {
        if (System.getProperty("QrInvoice.DebugLayout") != null) {
            rectangle.setBorder(15);
            rectangle.setBorderWidth(0.5f);
            rectangle.setBorderColor(Color.BLACK);
            writer.getDirectContent().rectangle(rectangle);
        }
    }

    private String neededLinesBreaks(float boxHeight, float lineHeight) {
        float calculatedNrOfNeededLineBreaks = boxHeight / lineHeight;
        int nrOfLineBreaks = (int)Math.ceil(calculatedNrOfNeededLineBreaks);
        char[] linebreaks = new char[nrOfLineBreaks];
        Arrays.fill(linebreaks, '\n');
        return String.valueOf(linebreaks);
    }

    private Chunk chunk(String text, Font font) {
        return this.chunk(text, false, font);
    }

    private Chunk chunk(String text, boolean newLine, Font font) {
        String chunkText = newLine ? text + "\n" : text;
        Chunk chunk = new Chunk(chunkText, font);
        Function<String, Float> widthFunction = str -> Float.valueOf(font.getBaseFont().getWidthPoint(str, font.getSize()));
        this.applyOptimalLineSplitting(text, this.paymentPartInformationSectionRect.getWidth(), widthFunction, () -> chunk.setSplitCharacter((SplitCharacter)SPLIT_ON_ALL_CHARACTERS));
        return chunk;
    }

    private Rectangle itextRectangle(Rect<Float> rect) {
        return new Rectangle(((Float)rect.getLowerLeftX()).floatValue(), ((Float)rect.getLowerLeftY()).floatValue(), ((Float)rect.getUpperRightX()).floatValue(), ((Float)rect.getUpperRightY()).floatValue());
    }

    private static final class SplitOnAllCharacters
    implements SplitCharacter {
        private SplitOnAllCharacters() {
        }

        public boolean isSplitCharacter(int start, int current, int end, char[] cc, PdfChunk[] ck) {
            return true;
        }
    }
}

