/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.qrcode;

import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.TechnicalException;
import ch.codeblock.qrinvoice.layout.DimensionUnitUtils;
import ch.codeblock.qrinvoice.layout.Rect;
import ch.codeblock.qrinvoice.output.QrCode;
import ch.codeblock.qrinvoice.qrcode.IQrCodeWriter;
import ch.codeblock.qrinvoice.qrcode.JavaGraphicsQrCodeWriter;
import ch.codeblock.qrinvoice.qrcode.QrCodeWriterOptions;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IText4QrCodeWriter
implements IQrCodeWriter {
    private static final Rect<Float> QR_CODE_RECTANGLE = Rect.create((Number)Float.valueOf(0.0f), (Number)Float.valueOf(0.0f), (Number)Float.valueOf(DimensionUnitUtils.millimetersToPoints((float)((Integer)QrInvoiceSpec.QR_CODE_SIZE.getWidth()).intValue())), (Number)Float.valueOf(DimensionUnitUtils.millimetersToPoints((float)((Integer)QrInvoiceSpec.QR_CODE_SIZE.getHeight()).intValue())));
    private final QrCodeWriterOptions options;

    public IText4QrCodeWriter(QrCodeWriterOptions options) {
        this.options = options;
    }

    public int getQrCodeImageSize() {
        int dpi = this.options.getOutputResolution().getDpi();
        float qrCodeMillimeters = ((Integer)QrInvoiceSpec.QR_CODE_SIZE.getWidth()).intValue();
        return DimensionUnitUtils.millimetersToPointsRounded((float)qrCodeMillimeters, (int)dpi);
    }

    public QrCode write(String qrCodeString) {
        QrCodeWriterOptions qrCodeWriterOptions = new QrCodeWriterOptions(this.options.getOutputFormat(), this.getQrCodeImageSize());
        BufferedImage qrCodeImage = JavaGraphicsQrCodeWriter.create((QrCodeWriterOptions)qrCodeWriterOptions).writeBufferedImage(qrCodeString);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(25600);
            Rectangle pageCanvas = new Rectangle(((Float)QR_CODE_RECTANGLE.getWidth()).floatValue(), ((Float)QR_CODE_RECTANGLE.getHeight()).floatValue());
            Document document = new Document(pageCanvas, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            this.addQrCodeImage(writer, qrCodeImage);
            document.close();
            return new QrCode(OutputFormat.PDF, baos.toByteArray());
        }
        catch (DocumentException | IOException e) {
            throw new TechnicalException("Unexpected exception occurred during the creation of the qr code", e);
        }
    }

    private void addQrCodeImage(PdfWriter writer, BufferedImage qrCodeImage) throws IOException, DocumentException {
        com.lowagie.text.Image image = com.lowagie.text.Image.getInstance((Image)qrCodeImage, null);
        image.setAbsolutePosition(((Float)QR_CODE_RECTANGLE.getLowerLeftX()).floatValue(), ((Float)QR_CODE_RECTANGLE.getLowerLeftY()).floatValue());
        float size = ((Float)QR_CODE_RECTANGLE.getWidth()).floatValue();
        image.scaleToFit(size, size);
        PdfContentByte canvas = writer.getDirectContent();
        canvas.addImage(image);
    }
}

