/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.infrastructure;

import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.infrastructure.IOutputWriterFactory;
import ch.codeblock.qrinvoice.paymentpart.IPaymentPartWriter;
import ch.codeblock.qrinvoice.paymentpart.IText4PaymentPartWriter;
import ch.codeblock.qrinvoice.paymentpart.PaymentPartWriterOptions;
import ch.codeblock.qrinvoice.qrcode.IQrCodeWriter;
import ch.codeblock.qrinvoice.qrcode.IText4QrCodeWriter;
import ch.codeblock.qrinvoice.qrcode.QrCodeWriterOptions;

public class IText4OutputWriterFactory
implements IOutputWriterFactory {
    public boolean supports(Object options) {
        if (options instanceof PaymentPartWriterOptions) {
            return this.supports((PaymentPartWriterOptions)options);
        }
        if (options instanceof QrCodeWriterOptions) {
            return this.supports((QrCodeWriterOptions)options);
        }
        return false;
    }

    public boolean supports(PaymentPartWriterOptions options) {
        return options.getOutputFormat().equals((Object)OutputFormat.PDF);
    }

    public IPaymentPartWriter create(PaymentPartWriterOptions options) {
        return new IText4PaymentPartWriter(options);
    }

    public boolean supports(QrCodeWriterOptions options) {
        return options.getOutputFormat().equals((Object)OutputFormat.PDF);
    }

    public IQrCodeWriter create(QrCodeWriterOptions options) {
        return new IText4QrCodeWriter(options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getShortName() {
        return this.getClass().getSimpleName().replace("PaymentPartWriterFactory", "");
    }
}

