/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin;

import ch.cmbntr.modulizer.bootstrap.util.SystemPropertyHelper;
import ch.cmbntr.modulizer.bootstrap.util.XMLFactories;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.Module;

@Mojo(name="early", defaultPhase=LifecyclePhase.VALIDATE)
public class EarlyInitMojo
extends AbstractMojo {
    public static final Map<String, String> FACTORIES = new HashMap<String, String>();
    @Parameter(defaultValue="true")
    private boolean inspectXMLFactories;
    @Parameter(defaultValue="false")
    private boolean jaxpDebug;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.xmlFactoriesInspection();
        this.jbossModulesPreloading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xmlFactoriesInspection() {
        Log log = this.getLog();
        if (this.inspectXMLFactories) {
            Properties orig = SystemPropertyHelper.snapshotProps();
            try {
                log.debug((CharSequence)orig.toString());
                if (this.jaxpDebug) {
                    System.setProperty("jaxp.debug", "true");
                }
                FACTORIES.putAll(XMLFactories.inspectXMLFactories());
            }
            catch (Throwable t) {
                log.error((CharSequence)"could not inspect XML factories, build environment is broken", t);
            }
            finally {
                SystemPropertyHelper.restoreProps((Properties)orig);
            }
            log.debug((CharSequence)FACTORIES.toString());
        }
    }

    private void jbossModulesPreloading() {
        Log log = this.getLog();
        log.debug((CharSequence)Module.class.toString());
        log.debug((CharSequence)LocalModuleLoader.class.toString());
    }
}

