/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin.config;

import ch.cmbntr.modulizer.plugin.config.ConfigBase;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.codehaus.plexus.util.StringUtils;

public class SigningInfo
extends ConfigBase {
    private static final String PASSWORD_MASK = "*****";
    private String alias;
    private String keypass;
    private String storetype = "pkcs12";
    private String keystore;
    private String storepass;
    private String[] arguments;
    private Properties signRequestProperties = new Properties();

    @Override
    public void checkParams() {
        super.checkParams();
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.alias), (Object)"no alias specified");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.keystore), (Object)"no keystore specified");
        try {
            File sanitized = new File(this.keystore).getCanonicalFile().getAbsoluteFile();
            Preconditions.checkState((boolean)sanitized.canRead(), (Object)("keystore not readable at " + sanitized));
            this.keystore = sanitized.getAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("problem with the keystore file", e);
        }
    }

    public JarSignerSignRequest signRequest(File workingDirectory, File archive) throws MojoExecutionException {
        JarSignerSignRequest request = new JarSignerSignRequest();
        request.setWorkingDirectory(workingDirectory);
        request.setArchive(archive);
        request.setAlias(this.alias);
        request.setKeypass(this.keypass);
        request.setStoretype(this.storetype);
        request.setKeystore(this.keystore);
        request.setStorepass(this.storepass);
        request.setArguments(this.arguments);
        this.setBeanProperties(request);
        return request;
    }

    private void setBeanProperties(JarSignerSignRequest request) throws MojoExecutionException {
        if (!this.signRequestProperties.isEmpty()) {
            try {
                HashSet props = Sets.newHashSet(this.signRequestProperties.keySet());
                BeanInfo i = Introspector.getBeanInfo(JarSignerSignRequest.class);
                for (PropertyDescriptor p : i.getPropertyDescriptors()) {
                    String name = p.getName();
                    if (!props.remove(name)) continue;
                    p.getWriteMethod().invoke((Object)request, this.signRequestProperties.getProperty(name));
                }
                if (!props.isEmpty()) {
                    throw new MojoExecutionException("the following properties have illegal names: " + props);
                }
            }
            catch (IllegalAccessException e) {
                this.failSetProperty(e);
            }
            catch (IllegalArgumentException e) {
                this.failSetProperty(e);
            }
            catch (InvocationTargetException e) {
                this.failSetProperty(e);
            }
            catch (IntrospectionException e) {
                this.failSetProperty(e);
            }
        }
    }

    private void failSetProperty(Exception e) throws MojoExecutionException {
        throw new MojoExecutionException("JarSignerSignRequest property setting failed", e);
    }

    @Override
    protected Objects.ToStringHelper prepareToStringHelper() {
        return super.prepareToStringHelper().add("alias", (Object)this.alias).add("keypass", (Object)(this.keypass == null ? null : PASSWORD_MASK)).add("keystore", (Object)this.keystore).add("storepass", (Object)(this.storepass == null ? null : PASSWORD_MASK)).add("arguments", (Object)this.arguments).add("signRequestProperties", (Object)this.signRequestProperties);
    }
}

