/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.filetree;

import ch.cmbntr.modulizer.bootstrap.impl.AbstractPrepare;
import ch.cmbntr.modulizer.bootstrap.util.ModulizerIO;
import ch.cmbntr.modulizer.bootstrap.util.Resources;
import ch.cmbntr.modulizer.filetree.FileTreeUtil;
import ch.cmbntr.modulizer.filetree.Restore;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.errors.GitAPIException;

public class FileTreePrepare
extends AbstractPrepare {
    private static final Pattern COPY_SRC_PATTERN = Pattern.compile("modulizer\\.filetree\\.copy\\.([^.]*)\\.src");
    private static final String COPY_DEST_TEMPLATE = "modulizer.filetree.copy.%s.dest";
    private static final long EXTRA_COPY_HASHING_TIMEOUT_MINUTES = 5L;
    private static final int NUM_ATTEMPTS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        File baseDir = this.determineWorkDirBase();
        boolean ignoreExisting = this.determineIgnoreExisting();
        Restore.CleanupMode cleanup = this.determineCleanupMode();
        int attempt = 1;
        while (attempt <= 3) {
            try {
                Future<URI> bundle = this.findBundle();
                File moduleRepo = this.determineDestination(baseDir, ignoreExisting || attempt != 1);
                String requiredRef = this.determineRequiredRef();
                String bundleRef = this.determineBundleRef();
                FileTreePrepare.log((String)"prepare file tree at %s", (Object[])new Object[]{moduleRepo});
                Restore.restore(moduleRepo, "master", requiredRef, bundle, bundleRef, cleanup);
                this.performExtraCopyJobs(this.findExtraCopyJobs());
                return;
            }
            catch (IOException e) {
                this.failPrepare(e, attempt);
            }
            catch (GitAPIException e) {
                this.failPrepare(e, attempt);
            }
            catch (RuntimeException e) {
                this.failPrepare(e, attempt);
            }
            finally {
                ++attempt;
            }
        }
    }

    private void failPrepare(Throwable e, int attempt) {
        FileTreePrepare.warn((String)"restoring file tree failed: %s", (Object[])new Object[]{e});
        if (attempt >= 3) {
            throw new RuntimeException(e);
        }
    }

    private boolean determineIgnoreExisting() {
        return Boolean.parseBoolean(this.lookupContext("modulizer.filetree.ignore-existing", "false"));
    }

    private Restore.CleanupMode determineCleanupMode() {
        return Restore.CleanupMode.valueOf(this.lookupContext("modulizer.filetree.cleanup", "FULL"));
    }

    private File determineWorkDirBase() {
        return new File(FileTreePrepare.lookupContext((String)"modulizer.bootstrap.app.dir"));
    }

    private File determineDestination(File baseDir, boolean ignoreExisting) throws IOException {
        File existing = ignoreExisting ? null : this.findExistingDestination(baseDir);
        File repo = existing == null ? new File(baseDir, FileTreeUtil.timestamp()) : existing;
        FileTreePrepare.putContext((String)"modulizer.bootstrap.app.dir", (String)repo.getAbsolutePath());
        return repo;
    }

    private File findExistingDestination(File baseDir) {
        if (!baseDir.isDirectory()) {
            return null;
        }
        Object[] contents = baseDir.list(FileTreeUtil.timestampDirs());
        if (contents == null || contents.length == 0) {
            return null;
        }
        Arrays.sort(contents);
        File existing = new File(baseDir, (String)contents[contents.length - 1]);
        if (existing.isDirectory() && FileTreeUtil.isTimestampDir(existing)) {
            return existing;
        }
        return null;
    }

    private String determineRequiredRef() {
        return FileTreePrepare.lookupContext((String)"modulizer.filetree.bundle.id");
    }

    private Future<URI> findBundle() {
        return Resources.submit((Callable)new Callable<URI>(){

            @Override
            public URI call() throws Exception {
                String given = FileTreePrepare.this.lookupContext("modulizer.filetree.bundle.uri", "/filetree.dat");
                URI bundleURI = URI.create(given);
                if (bundleURI.isAbsolute()) {
                    return bundleURI;
                }
                URL bundle = FileTreePrepare.class.getResource(given);
                if (bundle == null) {
                    throw new RuntimeException("could not find bundle resource: " + given);
                }
                return bundle.toURI();
            }
        });
    }

    private String determineBundleRef() {
        return this.lookupContext("modulizer.filetree.bundle.ref", "refs/heads/master");
    }

    private String lookupContext(String key, String defaultValue) {
        String value = FileTreePrepare.lookupContext((String)key);
        return value == null ? defaultValue : value;
    }

    private Map<File, Map<String, URL>> findExtraCopyJobs() {
        LinkedHashMap<File, Map<String, URL>> jobsByDest = new LinkedHashMap<File, Map<String, URL>>();
        for (String key : FileTreePrepare.findMatchingContextKeys((Pattern)COPY_SRC_PATTERN)) {
            Matcher m = COPY_SRC_PATTERN.matcher(key);
            if (!m.matches()) continue;
            String jobLabel = m.group(1);
            String src = FileTreePrepare.lookupContextInterpolated((String)key);
            String dest = FileTreePrepare.lookupContextInterpolated((String)String.format(COPY_DEST_TEMPLATE, jobLabel));
            if (dest == null) {
                FileTreePrepare.warn((String)"missing dest for copy job '%s'", (Object[])new Object[]{jobLabel});
                continue;
            }
            try {
                jobsByDest.put(this.copyDestinationToFile(dest), Collections.singletonMap(jobLabel, FileTreePrepare.copySourceToURL(src)));
            }
            catch (RuntimeException e) {
                FileTreePrepare.failExtraCopyJob(jobLabel, e);
            }
        }
        return jobsByDest;
    }

    private static URL copySourceToURL(String src) {
        try {
            File f = new File(src).getAbsoluteFile();
            if (f.canRead()) {
                return f.toURI().toURL();
            }
            FileTreePrepare.log((String)"copy job source is not a readable file, try as URL", (Object[])new Object[0]);
            return new URL(src);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("could not create source URL for copy job, src=" + src, e);
        }
    }

    private File copyDestinationToFile(String dest) {
        File f = new File(dest).getAbsoluteFile();
        File p = f.getParentFile();
        if (p.isDirectory()) {
            return f;
        }
        throw new RuntimeException("parent directory for copy job does not exist, dest=" + dest);
    }

    private void performExtraCopyJobs(Map<File, Map<String, URL>> jobsByDest) {
        for (Map.Entry<File, Map<String, URL>> destAndSrcByLabel : jobsByDest.entrySet()) {
            for (Map.Entry<String, URL> entry : destAndSrcByLabel.getValue().entrySet()) {
                String jobLabel = entry.getKey();
                try {
                    URL src = entry.getValue();
                    File dest = destAndSrcByLabel.getKey();
                    FileTreePrepare.log((String)"copy job '%s': [%s] to [%s]", (Object[])new Object[]{jobLabel, src, dest});
                    if (this.canSkipCopy(src, dest)) {
                        FileTreePrepare.log((String)"skip job '%s', because file exists and content matches", (Object[])new Object[]{jobLabel});
                        continue;
                    }
                    ModulizerIO.copyStream((URL)src, (File)dest);
                }
                catch (IOException e) {
                    FileTreePrepare.failExtraCopyJob(jobLabel, e);
                }
                catch (RuntimeException e) {
                    FileTreePrepare.failExtraCopyJob(jobLabel, e);
                }
            }
        }
    }

    private boolean canSkipCopy(URL src, File dest) {
        try {
            if (dest.exists()) {
                URI s = src.toURI();
                URI d = dest.toURI();
                LinkedHashMap x = ModulizerIO.sha1URIasync(Arrays.asList(s, d));
                String srcHash = this.hashOrNull((Future)x.get(s));
                String destHash = this.hashOrNull((Future)x.get(d));
                return srcHash != null && destHash != null && srcHash.equals(destHash);
            }
            return false;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String hashOrNull(Future<String> hash) {
        try {
            return hash.get(5L, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            FileTreePrepare.log((String)"hashing failed: %s", (Object[])new Object[]{e.getCause().getMessage()});
        }
        catch (InterruptedException e) {
            FileTreePrepare.log((String)"hashing interrupted", (Object[])new Object[0]);
        }
        catch (TimeoutException e) {
            FileTreePrepare.log((String)"hashing timout", (Object[])new Object[0]);
        }
        return null;
    }

    private static void failExtraCopyJob(String jobLabel, Exception e) {
        FileTreePrepare.warn((String)"copy job '%s' failed: %s", (Object[])new Object[]{jobLabel, e.getMessage()});
        throw new RuntimeException(String.format("copy job '%s' failed", jobLabel), e);
    }
}

