/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.filetree;

import ch.cmbntr.modulizer.bootstrap.util.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.TransportBundleStream;
import org.eclipse.jgit.transport.URIish;

public class Restore {
    private static final Logger LOG = Logger.getAnonymousLogger();

    private Restore() {
    }

    private static void log(String msg, Object ... args) {
        LOG.fine(String.format(msg, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(File destination, String branch, String requiredRef, Future<URI> bundle, String bundleRef, CleanupMode cleanup) throws IOException, GitAPIException {
        try {
            Git git = Restore.exists(destination);
            try {
                if (git == null || !Restore.headAt(git, requiredRef)) {
                    URI b = (URI)Resources.get(bundle, (String)"failed to get bundle");
                    Restore.explodeBundle(destination, branch, bundleRef, b, cleanup);
                } else {
                    bundle.cancel(true);
                    Restore.ensureClean(git, cleanup);
                }
            }
            finally {
                if (git != null) {
                    git.getRepository().close();
                }
            }
        }
        finally {
            RepositoryCache.clear();
        }
        Restore.log("prepared", new Object[0]);
    }

    private static void ensureClean(Git git, CleanupMode cleanup) throws NoWorkTreeException, GitAPIException {
        if (CleanupMode.NONE.equals((Object)cleanup)) {
            Restore.log("skip cleanup", new Object[0]);
            return;
        }
        Status st = git.status().call();
        if (st.isClean()) {
            Restore.log("ready", new Object[0]);
        } else {
            Restore.log("not clean", new Object[0]);
            git.reset().setMode(ResetCommand.ResetType.HARD).call();
            Status st2 = git.status().call();
            if (st2.isClean() || !st.getUntracked().isEmpty()) {
                Restore.log("ready", new Object[0]);
            }
        }
    }

    private static Git exists(File worktree) {
        try {
            return Git.open((File)worktree);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean headAt(Git git, String required) {
        try {
            Repository repo = git.getRepository();
            String branch = repo.getFullBranch();
            Ref ref = repo.getRef(branch);
            return ref != null && required.equals(ref.getObjectId().getName());
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String explodeBundle(File worktree, String branchName, String refName, URI bundle, CleanupMode cleanup) throws IOException, GitAPIException {
        if (!worktree.exists() && !worktree.mkdirs()) {
            throw new IOException("could not create " + worktree);
        }
        if (!worktree.canWrite()) {
            throw new IOException("not writable: " + worktree);
        }
        Git git = Git.init().setDirectory(worktree).call();
        try {
            String ref = Restore.fetchBundle(git, bundle, refName);
            git.branchCreate().setName(branchName).setForce(true).setStartPoint(ref).call();
            String head = git.checkout().setName(branchName).call().getObjectId().getName();
            Restore.ensureClean(git, cleanup);
            String string = head;
            return string;
        }
        finally {
            git.getRepository().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchBundle(Git git, URI bundle, String refName) throws IOException {
        URL loc = bundle.toURL();
        URIish uri = new URIish(loc);
        TransportBundleStream t = new TransportBundleStream(git.getRepository(), uri, loc.openStream());
        try {
            FetchConnection src = t.openFetch();
            Ref target = src.getRef(refName);
            Set<Ref> want = Collections.singleton(target);
            Set have = Collections.emptySet();
            src.fetch((ProgressMonitor)NullProgressMonitor.INSTANCE, want, have);
            String string = target.getObjectId().getName();
            return string;
        }
        finally {
            t.close();
        }
    }

    public static enum CleanupMode {
        NONE,
        RESET_ONLY,
        FULL;

    }
}

