/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.filetree;

import ch.cmbntr.modulizer.bootstrap.impl.AbstractPrepare;
import ch.cmbntr.modulizer.bootstrap.util.Resources;
import ch.cmbntr.modulizer.filetree.FileTreeUtil;
import ch.cmbntr.modulizer.filetree.Restore;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.jgit.api.errors.GitAPIException;

public class FileTreePrepare
extends AbstractPrepare {
    private static final int NUM_ATTEMPTS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        File baseDir = this.determineWorkDirBase();
        boolean ignoreExisting = this.determineIgnoreExisting();
        Restore.CleanupMode cleanup = this.determineCleanupMode();
        int attempt = 1;
        while (attempt <= 3) {
            try {
                Future<URI> bundle = this.findBundle();
                File moduleRepo = this.determineDestination(baseDir, ignoreExisting || attempt != 1);
                String requiredRef = this.determineRequiredRef();
                String bundleRef = this.determineBundleRef();
                FileTreePrepare.log((String)"prepare file tree at %s", (Object[])new Object[]{moduleRepo});
                Restore.restore(moduleRepo, "master", requiredRef, bundle, bundleRef, cleanup);
                return;
            }
            catch (IOException e) {
                this.failPrepare(e, attempt);
            }
            catch (GitAPIException e) {
                this.failPrepare(e, attempt);
            }
            catch (RuntimeException e) {
                this.failPrepare(e, attempt);
            }
            finally {
                ++attempt;
            }
        }
    }

    private void failPrepare(Throwable e, int attempt) {
        FileTreePrepare.warn((String)"restoring file tree failed: %s", (Object[])new Object[]{e});
        if (attempt >= 3) {
            throw new RuntimeException(e);
        }
    }

    private boolean determineIgnoreExisting() {
        return Boolean.parseBoolean(this.lookupContext("modulizer.filetree.ignore-existing", "false"));
    }

    private Restore.CleanupMode determineCleanupMode() {
        return Restore.CleanupMode.valueOf(this.lookupContext("modulizer.filetree.cleanup", "FULL"));
    }

    private File determineWorkDirBase() {
        return new File(FileTreePrepare.lookupContext((String)"modulizer.bootstrap.app.dir"));
    }

    private File determineDestination(File baseDir, boolean ignoreExisting) throws IOException {
        File existing = ignoreExisting ? null : this.findExistingDestination(baseDir);
        File repo = existing == null ? new File(baseDir, FileTreeUtil.timestamp()) : existing;
        FileTreePrepare.putContext((String)"modulizer.bootstrap.app.dir", (String)repo.getAbsolutePath());
        return repo;
    }

    private File findExistingDestination(File baseDir) {
        if (!baseDir.isDirectory()) {
            return null;
        }
        Object[] contents = baseDir.list();
        if (contents == null || contents.length == 0) {
            return null;
        }
        Arrays.sort(contents);
        File existing = new File(baseDir, (String)contents[contents.length - 1]);
        if (existing.isDirectory() && FileTreeUtil.isTimestampDir(existing)) {
            return existing;
        }
        return null;
    }

    private String determineRequiredRef() {
        return FileTreePrepare.lookupContext((String)"modulizer.filetree.bundle.id");
    }

    private Future<URI> findBundle() {
        return Resources.submit((Callable)new Callable<URI>(){

            @Override
            public URI call() throws Exception {
                String given = FileTreePrepare.this.lookupContext("modulizer.filetree.bundle.uri", "/filetree.dat");
                URI bundleURI = URI.create(given);
                if (bundleURI.isAbsolute()) {
                    return bundleURI;
                }
                URL bundle = FileTreePrepare.class.getResource(given);
                if (bundle == null) {
                    throw new RuntimeException("could not find bundle resource: " + given);
                }
                return bundle.toURI();
            }
        });
    }

    private String determineBundleRef() {
        return this.lookupContext("modulizer.filetree.bundle.ref", "refs/heads/master");
    }

    private String lookupContext(String key, String defaultValue) {
        String value = FileTreePrepare.lookupContext((String)key);
        return value == null ? defaultValue : value;
    }
}

