/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap.util;

import ch.cmbntr.modulizer.bootstrap.util.ModulizerLog;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SystemPropertyHelper {
    private static final Map<String, String> EXPORT = new HashMap<String, String>();

    private SystemPropertyHelper() {
    }

    public static Properties snapshotProps() {
        Properties snapshot = new Properties();
        snapshot.putAll((Map<?, ?>)System.getProperties());
        return snapshot;
    }

    public static synchronized void export(String key, String value) {
        try {
            EXPORT.put(key, value);
            System.setProperty(key, value);
        }
        catch (SecurityException e) {
            ModulizerLog.warn("could not set property %s to %s", key, value);
        }
    }

    public static synchronized void restoreProps(Properties origProps) {
        if (origProps == null) {
            return;
        }
        try {
            origProps.putAll(EXPORT);
            EXPORT.clear();
            System.setProperties(origProps);
        }
        catch (SecurityException e) {
            ModulizerLog.warn("could not restore properties", new Object[0]);
        }
    }
}

