/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap.util;

import ch.cmbntr.modulizer.bootstrap.util.ModulizerLog;
import ch.cmbntr.modulizer.bootstrap.util.Resources;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Preloading {
    private Preloading() {
    }

    public static void preload(final boolean requiresGUI, final ClassLoader loader, final String preloadSpec) {
        if (preloadSpec == null) {
            return;
        }
        Resources.execute(new Runnable(){

            @Override
            public void run() {
                if (requiresGUI && GraphicsEnvironment.isHeadless()) {
                    return;
                }
                for (final List slice : Preloading.parsePreloadSpec(preloadSpec)) {
                    Resources.delay(0L, new Runnable(){

                        @Override
                        public void run() {
                            for (String clazz : slice) {
                                try {
                                    Class.forName(clazz, true, loader);
                                }
                                catch (ClassNotFoundException e) {
                                    ModulizerLog.warn("preload of %s failed: %s", clazz, e.getMessage());
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private static List<List<String>> parsePreloadSpec(String barSeparatedClassLists) {
        if (barSeparatedClassLists == null) {
            return Collections.emptyList();
        }
        String[] slices = barSeparatedClassLists.split("\\|");
        if (slices.length == 1) {
            return Collections.singletonList(Preloading.classNames(slices[0]));
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(slices.length);
        for (String slice : slices) {
            List<String> classes = Preloading.classNames(slice);
            if (classes.isEmpty()) continue;
            result.add(classes);
        }
        return result;
    }

    public static List<String> classNames(String commaSeparatedClasses) {
        String[] classes = commaSeparatedClasses.split(",");
        ArrayList<String> result = new ArrayList<String>(classes.length);
        for (String clazz : classes) {
            String trimmed = clazz.trim();
            if (trimmed.length() <= 0) continue;
            result.add(trimmed);
        }
        return result;
    }
}

