/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SocketHandler;
import java.util.logging.StreamHandler;

public class ModulizerLog {
    private static final Logger LOG = Logger.getAnonymousLogger();

    private ModulizerLog() {
    }

    public static void log(String msg, Object ... args) {
        ModulizerLog.emit(Level.FINE, msg, args);
    }

    public static void warn(String msg, Object ... args) {
        ModulizerLog.emit(Level.WARNING, msg, args);
    }

    private static void emit(Level level, String msg, Object ... args) {
        if (LOG.isLoggable(level)) {
            LOG.log(level, String.format(msg, args));
        }
    }

    public static void initLogging(String config) {
        if (config != null) {
            LogConfig.configure(LOG, config);
        }
    }

    static {
        ModulizerLog.initLogging(System.getProperty("modulizer.logging"));
    }

    private static final class LogConfig {
        private static final Set<String> ACTIVE = new HashSet<String>();

        private LogConfig() {
        }

        public static synchronized void configure(Logger log, String config) {
            log.setLevel(Level.ALL);
            for (String h : config.split("\\|")) {
                StreamHandler handler;
                if (ACTIVE.contains(h) || (handler = LogConfig.configureHandler(log, h)) == null) continue;
                log.addHandler(handler);
                ACTIVE.add(h);
            }
        }

        private static StreamHandler createHandler(Logger log, String config) {
            try {
                if (config.startsWith("console")) {
                    return new ConsoleHandler();
                }
                if (config.startsWith("file:")) {
                    return new FileHandler(config.substring(5));
                }
                if (config.startsWith("file")) {
                    return new FileHandler("%h/modulizer%u.log");
                }
                if (config.startsWith("socket:")) {
                    URI cfg = URI.create(config);
                    return new SocketHandler(cfg.getHost(), cfg.getPort());
                }
                return null;
            }
            catch (Exception e) {
                log.log(Level.CONFIG, "invalid logging config: " + config, e);
                return null;
            }
        }

        private static StreamHandler configureHandler(Logger log, String config) {
            StreamHandler handler = LogConfig.createHandler(log, config);
            if (handler == null) {
                return null;
            }
            handler.setLevel(Level.ALL);
            handler.setFormatter(LogFormatter.INSTANCE);
            try {
                handler.setEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warning("UTF-8 not supported!");
            }
            return handler;
        }
    }

    private static final class LogFormatter
    extends Formatter {
        public static final LogFormatter INSTANCE = new LogFormatter();

        private LogFormatter() {
        }

        @Override
        public String format(LogRecord r) {
            return String.format("MODULIZER: %s,T%s,%s,%s\n", r.getMillis(), r.getThreadID(), r.getLevel(), r.getMessage());
        }
    }

    public static final class ExceptionLogger
    implements Thread.UncaughtExceptionHandler {
        public static ExceptionLogger create() {
            return new ExceptionLogger();
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            StringBuilder msg = new StringBuilder(e.getMessage());
            msg.append('\n');
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            e.printStackTrace(pw);
            msg.append(sw.getBuffer().toString());
            LOG.severe(msg.toString());
        }
    }
}

