/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap.util;

import ch.cmbntr.modulizer.bootstrap.util.Resources;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ModulizerIO {
    private static final int FF_BITMASK = 255;

    private ModulizerIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL copyStream(URL src, File dest) throws IOException, FileNotFoundException, MalformedURLException {
        InputStream in = src.openStream();
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                ModulizerIO.copy(in, out);
            }
            finally {
                ModulizerIO.closeQuietly(out);
            }
        }
        finally {
            ModulizerIO.closeQuietly(in);
        }
        return dest.toURI().toURL();
    }

    private static String baseName(String path) {
        File f = new File(path);
        String n = f.getName();
        int idx = n.lastIndexOf(46);
        return idx >= 0 ? n.substring(0, idx) : n;
    }

    private static String extension(String name, String ifNone) {
        int idx = name.lastIndexOf(46);
        return idx >= 0 ? name.substring(idx + 1) : ifNone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream input, OutputStream output) throws IOException {
        ReadableByteChannel in = ModulizerIO.inChannel(input);
        WritableByteChannel out = ModulizerIO.outChannel(output);
        Resources.Pool pool = Resources.getPoolHandle();
        ByteBuffer buffer = pool.aquireBuffer();
        try {
            while (in.read(buffer) != -1) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    int n = out.write(buffer);
                    if (n >= 1) continue;
                    throw new IOException("write stalled");
                }
                buffer.clear();
            }
        }
        finally {
            pool.releaseBuffer(buffer);
        }
    }

    private static ReadableByteChannel inChannel(InputStream input) {
        if (input instanceof FileInputStream) {
            return ((FileInputStream)input).getChannel();
        }
        return Channels.newChannel(input);
    }

    private static WritableByteChannel outChannel(OutputStream output) {
        if (output instanceof FileOutputStream) {
            return ((FileOutputStream)output).getChannel();
        }
        return Channels.newChannel(output);
    }

    public static synchronized void mkdir(File dir) throws IOException {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return;
            }
            throw new IOException(dir + " already exists is not a directory");
        }
        boolean created = dir.mkdirs();
        if (!created || !dir.isDirectory()) {
            throw new IOException("could not create dir " + dir);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        block3: {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || e != null) break block3;
                throw new AssertionError();
            }
        }
    }

    public static boolean verifySHA1Named(File f) throws IOException {
        StringBuilder sha1 = ModulizerIO.sha1(f);
        return sha1 != null && ModulizerIO.baseName(f.getName()).equals(sha1.toString());
    }

    public static String sha1Name(File f) throws IOException {
        StringBuilder sha1 = ModulizerIO.sha1(f);
        return sha1 == null ? null : sha1.append('.').append(ModulizerIO.extension(f.getName(), "dat")).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<File, Future<String>> sha1async(Iterable<File> files) {
        LinkedHashMap<File, Future<String>> result = new LinkedHashMap<File, Future<String>>();
        Resources.Pool pool = Resources.getPoolHandle();
        ExecutorService exec = pool.aquireExec();
        try {
            for (final File f : files) {
                result.put(f, exec.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        StringBuilder sha1 = ModulizerIO.sha1(f);
                        return sha1 == null ? null : sha1.toString();
                    }
                }));
            }
            LinkedHashMap<File, Future<String>> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            pool.releaseExec(exec);
        }
    }

    public static StringBuilder sha1(File f) throws IOException {
        if (f == null || !f.exists()) {
            return null;
        }
        return ModulizerIO.sha1(new FileInputStream(f).getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<URI, Future<String>> sha1URIasync(Iterable<URI> uris) {
        LinkedHashMap<URI, Future<String>> result = new LinkedHashMap<URI, Future<String>>();
        Resources.Pool pool = Resources.getPoolHandle();
        ExecutorService exec = pool.aquireExec();
        try {
            for (final URI f : uris) {
                result.put(f, exec.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        StringBuilder sha1 = ModulizerIO.sha1URI(f);
                        return sha1 == null ? null : sha1.toString();
                    }
                }));
            }
            LinkedHashMap<URI, Future<String>> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            pool.releaseExec(exec);
        }
    }

    public static StringBuilder sha1URI(URI uri) throws IOException {
        if (uri == null) {
            return null;
        }
        if ("file".equals(uri.getScheme())) {
            return ModulizerIO.sha1(new FileInputStream(new File(uri)).getChannel());
        }
        return ModulizerIO.sha1(Channels.newChannel(uri.toURL().openStream()));
    }

    /*
     * Exception decompiling
     */
    private static StringBuilder sha1(ReadableByteChannel src) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static StringBuilder formatAsHex(byte[] digestBytes) {
        StringBuilder result = new StringBuilder(44);
        for (byte b : digestBytes) {
            String next = Integer.toHexString(b & 0xFF);
            if (next.length() < 2) {
                result.append('0');
            }
            result.append(next);
        }
        return result;
    }
}

