/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap;

import ch.cmbntr.modulizer.bootstrap.Operation;
import ch.cmbntr.modulizer.bootstrap.util.ModulizerIO;
import ch.cmbntr.modulizer.bootstrap.util.ModulizerLog;
import ch.cmbntr.modulizer.bootstrap.util.Resources;
import ch.cmbntr.modulizer.bootstrap.util.SystemPropertyHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class Operations {
    private Operations() {
    }

    public static ClassLoader defaultLoader() {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        return tcl == null ? Operations.class.getClassLoader() : tcl;
    }

    public static <S extends Operation> void invokeOperations(Class<S> operationType, Future<ClassLoader> loader) {
        Operations.invokeOperations(operationType, Resources.get(loader, "failed to get classloader"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Operation> void invokeOperations(Class<S> operationType, ClassLoader loader) {
        ModulizerLog.log("invoke %s operations", operationType.getSimpleName());
        Thread currentThread = Thread.currentThread();
        ClassLoader origCCL = currentThread.getContextClassLoader();
        Properties origProps = SystemPropertyHelper.snapshotProps();
        try {
            Iterator<S> ops = Operations.findOperations(operationType, loader);
            while (ops.hasNext()) {
                Operation op = (Operation)ops.next();
                Class<?> operationClass = op.getClass();
                ClassLoader opLoader = operationClass.getClassLoader();
                ModulizerLog.log("invoke %s from %s", operationClass.getName(), Operations.classLoaderInfo(opLoader));
                currentThread.setContextClassLoader(opLoader);
                op.run();
            }
        }
        finally {
            currentThread.setContextClassLoader(origCCL);
            SystemPropertyHelper.restoreProps(origProps);
        }
    }

    private static <S extends Operation> Iterator<S> findOperations(Class<S> operationType, ClassLoader loader) {
        return ServiceLoader.load(operationType, loader).iterator();
    }

    private static String classLoaderInfo(ClassLoader cl) {
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            return Arrays.toString(ucl.getURLs());
        }
        return cl.toString();
    }

    public static final class PluginLoader
    implements Callable<ClassLoader> {
        private final File dir;
        private final String spec;

        private PluginLoader(File dir, String spec) {
            this.dir = dir;
            this.spec = spec;
        }

        public static PluginLoader create(File dir, String spec) {
            return new PluginLoader(dir, spec);
        }

        @Override
        public ClassLoader call() throws Exception {
            return PluginLoader.pluginLoader(Operations.defaultLoader(), this.dir, this.spec);
        }

        private static ClassLoader pluginLoader(ClassLoader parent, File pluginDir, String pluginSpec) {
            if (pluginSpec == null) {
                ModulizerLog.log("no plugins specified", new Object[0]);
                return parent;
            }
            try {
                LinkedList<URL> plugins = new LinkedList<URL>();
                for (String url : pluginSpec.split(",")) {
                    String pluginURI = url.trim();
                    ModulizerLog.log("plugin: %s", pluginURI);
                    URI p = URI.create(pluginURI);
                    if (p.isAbsolute()) {
                        plugins.add(p.toURL());
                        continue;
                    }
                    ModulizerIO.mkdir(pluginDir);
                    String jarPath = p.getPath();
                    File pluginDest = new File(pluginDir, jarPath);
                    if (ModulizerIO.verifySHA1Named(pluginDest)) {
                        plugins.add(pluginDest.toURI().toURL());
                        continue;
                    }
                    URL jar = parent.getResource(jarPath);
                    if (jar == null) {
                        ModulizerLog.warn("could not find plugin jar:  %s", jarPath);
                        continue;
                    }
                    plugins.add(ModulizerIO.copyStream(jar, pluginDest));
                }
                ModulizerLog.log("plugins: %s", plugins);
                if (plugins.isEmpty()) {
                    return parent;
                }
                return new URLClassLoader(PluginLoader.toURLArray(plugins), parent);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static URL[] toURLArray(List<URL> urls) {
            URL[] a = new URL[urls.size()];
            return urls.toArray(a);
        }
    }
}

