/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap.util;

import ch.cmbntr.modulizer.bootstrap.util.ModulizerLog;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLFactories {
    private static final String SCHEMA_FACTORY_PREFIX = "javax.xml.validation.SchemaFactory";
    private static final String XSD_FACTORY = "javax.xml.validation.SchemaFactoryhttp://www.w3.org/2001/XMLSchema";
    private static final Map<String, String> FALLBACKS;
    private static final Set<String> XML_FACTORIES;

    private XMLFactories() {
    }

    public static Map<String, String> inspectXMLFactories() {
        HashMap<String, String> factories = new HashMap<String, String>();
        Collection<Throwable> failures = XMLFactories.inspect(factories);
        if (failures.isEmpty()) {
            return factories;
        }
        throw new RuntimeException("failed XML Factories: " + failures);
    }

    public static void installFallbacks() {
        HashMap<String, String> ok = new HashMap<String, String>();
        Collection<Throwable> failures = XMLFactories.inspect(ok);
        if (failures.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, String>> fb = FALLBACKS.entrySet();
        for (Map.Entry<String, String> fallback : fb) {
            String factory = fallback.getKey();
            if (ok.containsKey(factory)) continue;
            System.setProperty(factory, fallback.getValue());
        }
    }

    private static Collection<Throwable> inspect(Map<String, String> results) {
        LinkedList<Throwable> failures = new LinkedList<Throwable>();
        try {
            XMLFactories.register(results, "javax.xml.parsers.DocumentBuilderFactory", DocumentBuilderFactory.newInstance());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        try {
            XMLFactories.register(results, "javax.xml.parsers.SAXParserFactory", SAXParserFactory.newInstance());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        try {
            XMLFactories.register(results, "javax.xml.transform.TransformerFactory", TransformerFactory.newInstance());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        try {
            XMLFactories.register(results, "javax.xml.xpath.XPathFactory", XPathFactory.newInstance());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        try {
            XMLFactories.register(results, "javax.xml.stream.XMLEventFactory", XMLEventFactory.newInstance());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        try {
            XMLFactories.register(results, "javax.xml.stream.XMLInputFactory", XMLInputFactory.newInstance());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        try {
            XMLFactories.register(results, "javax.xml.stream.XMLOutputFactory", XMLOutputFactory.newInstance());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        try {
            XMLFactories.register(results, "javax.xml.datatype.DatatypeFactory", DatatypeFactory.newInstance());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        try {
            XMLFactories.register(results, "org.xml.sax.driver", XMLReaderFactory.createXMLReader());
        }
        catch (Throwable t) {
            failures.add(t);
        }
        try {
            XMLFactories.register(results, XSD_FACTORY, SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema"));
        }
        catch (Throwable t) {
            failures.add(t);
        }
        return failures;
    }

    private static void register(Map<String, String> factories, String configKey, Object instance) {
        if (instance != null) {
            factories.put(configKey, instance.getClass().getName());
        }
    }

    public static void clearXMLFactories() {
        XMLFactories.clearXMLFactories(System.getProperties());
    }

    public static Properties clearXMLFactories(Properties props) {
        for (String factory : XML_FACTORIES) {
            XMLFactories.clear(props, factory);
        }
        for (Object k : props.keySet()) {
            if (!k.toString().startsWith(SCHEMA_FACTORY_PREFIX)) continue;
            XMLFactories.clear(props, k);
        }
        return props;
    }

    private static void clear(Properties props, Object key) {
        if (props.remove(key) != null) {
            ModulizerLog.log("cleared property %s", key);
        }
    }

    static {
        LinkedHashMap<String, String> f = new LinkedHashMap<String, String>();
        f.put("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        f.put("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        f.put("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        f.put("javax.xml.xpath.XPathFactory", "com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl");
        f.put("javax.xml.stream.XMLEventFactory", "com.sun.xml.internal.stream.events.XMLEventFactoryImpl");
        f.put("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
        f.put("javax.xml.stream.XMLOutputFactory", "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
        f.put("javax.xml.datatype.DatatypeFactory", "com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl");
        f.put("org.xml.sax.driver", "com.sun.org.apache.xerces.internal.parsers.SAXParser");
        f.put(XSD_FACTORY, "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory");
        FALLBACKS = Collections.unmodifiableMap(f);
        XML_FACTORIES = FALLBACKS.keySet();
    }
}

