/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap.util;

import ch.cmbntr.modulizer.bootstrap.util.ModulizerLog;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class Resources {
    private static final ThreadFactory THREAD_FACTORY = new ModulizerThreadFactory();
    private static WeakReference<Pool> pool;

    private Resources() {
    }

    public static Thread newThread(String threadName, Runnable runnable) {
        Thread t = THREAD_FACTORY.newThread(runnable);
        t.setName(threadName);
        return t;
    }

    public static synchronized Pool getPoolHandle() {
        Pool p;
        Pool pool = p = Resources.pool == null ? null : (Pool)Resources.pool.get();
        if (p == null) {
            p = new BasicPool();
            Resources.pool = new WeakReference<Pool>(p);
            ModulizerLog.log("init resources pool: %s", p);
        }
        return p;
    }

    public static synchronized void dispose(Pool handle) {
        pool = null;
        ModulizerLog.log("dispose pool: %s", handle);
        if (handle instanceof BasicPool) {
            ((BasicPool)handle).dispose();
        }
    }

    public static <T> Future<T> submit(Callable<T> work) {
        return Resources.submit(Resources.getPoolHandle(), work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Future<T> submit(Pool pool, Callable<T> work) {
        ExecutorService exec = pool.aquireExec();
        try {
            Future<T> future = exec.submit(work);
            return future;
        }
        finally {
            pool.releaseExec(exec);
        }
    }

    public static void execute(Runnable work) {
        Resources.execute(Resources.getPoolHandle(), work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Pool pool, Runnable work) {
        ExecutorService exec = pool.aquireExec();
        try {
            exec.execute(work);
        }
        finally {
            pool.releaseExec(exec);
        }
    }

    public static <T> T get(Future<T> holder, String errorMsg) {
        try {
            return holder.get(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw Resources.failGet(errorMsg, e);
        }
        catch (ExecutionException e) {
            throw Resources.failGet(errorMsg, e.getCause());
        }
        catch (TimeoutException e) {
            throw Resources.failGet(errorMsg, e);
        }
    }

    private static RuntimeException failGet(String msg, Throwable cause) {
        throw new RuntimeException(msg, cause);
    }

    private static final class ModulizerThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger THREAD_NUMBER = new AtomicInteger(1);
        private static final ThreadGroup THREAD_GROUP = new ThreadGroup("modulizer threads");

        private ModulizerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(THREAD_GROUP, r, "modulizer thread - " + THREAD_NUMBER.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class BasicPool
    implements Pool {
        private static final int POOL_SIZE = Math.max(2, Runtime.getRuntime().availableProcessors());
        private static final int BUFFER_SIZE = 32768;
        private final BlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>(POOL_SIZE);
        private final BlockingDeque<MessageDigest> digests = new LinkedBlockingDeque<MessageDigest>(POOL_SIZE);
        private ThreadPoolExecutor exec;
        private ThreadPoolExecutor blockableExec;

        private BasicPool() {
        }

        private static ThreadPoolExecutor buildNonBlockableExecutor() {
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            ThreadPoolExecutor tpe = new ThreadPoolExecutor(POOL_SIZE, POOL_SIZE, 15L, TimeUnit.SECONDS, workQueue, THREAD_FACTORY);
            tpe.allowCoreThreadTimeOut(true);
            tpe.prestartCoreThread();
            return tpe;
        }

        private static ThreadPoolExecutor buildBlockableExecutor() {
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 15L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), THREAD_FACTORY);
        }

        private synchronized void dispose() {
            if (this.exec != null) {
                this.exec.shutdown();
            }
            if (this.blockableExec != null) {
                this.blockableExec.shutdown();
            }
            this.buffers.clear();
            this.digests.clear();
        }

        @Override
        public synchronized ExecutorService aquireExec() {
            if (this.exec == null) {
                this.exec = BasicPool.buildNonBlockableExecutor();
            }
            return this.exec;
        }

        @Override
        public void releaseExec(ExecutorService svc) {
        }

        @Override
        public synchronized ExecutorService aquireBlockableExec() {
            if (this.blockableExec == null) {
                this.blockableExec = BasicPool.buildBlockableExecutor();
            }
            return this.blockableExec;
        }

        @Override
        public void releaseBlockableExec(ExecutorService svc) {
        }

        @Override
        public ByteBuffer aquireBuffer() {
            ByteBuffer b = BasicPool.pop(this.buffers);
            if (b == null) {
                return ByteBuffer.allocate(32768);
            }
            b.clear();
            return b;
        }

        @Override
        public void releaseBuffer(ByteBuffer buf) {
            BasicPool.push(this.buffers, buf);
        }

        @Override
        public MessageDigest aquireDigest() {
            MessageDigest d = BasicPool.pop(this.digests);
            if (d == null) {
                try {
                    return MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            d.reset();
            return d;
        }

        @Override
        public void releaseDigest(MessageDigest digest) {
            BasicPool.push(this.digests, digest);
        }

        private static <T> T pop(BlockingDeque<T> lifo) {
            return (T)lifo.pollFirst();
        }

        private static <T> boolean push(BlockingDeque<T> lifo, T item) {
            return lifo.offerFirst(item);
        }

        public String toString() {
            return String.format("%s[buffers=%d, digests=%d, nonblockableThreads=%s, blockableThreads=%s]", super.toString(), this.buffers.size(), this.digests.size(), BasicPool.threadCount(this.exec), BasicPool.threadCount(this.blockableExec));
        }

        private static String threadCount(ThreadPoolExecutor e) {
            return e == null ? "NA" : e.getActiveCount() + "/" + e.getLargestPoolSize();
        }
    }

    public static interface Pool {
        public ExecutorService aquireExec();

        public void releaseExec(ExecutorService var1);

        public ExecutorService aquireBlockableExec();

        public void releaseBlockableExec(ExecutorService var1);

        public ByteBuffer aquireBuffer();

        public void releaseBuffer(ByteBuffer var1);

        public MessageDigest aquireDigest();

        public void releaseDigest(MessageDigest var1);
    }
}

