/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing;

import com.sun.tracing.Probe;
import com.sun.tracing.Provider;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import sun.tracing.ProbeSkeleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiplexProbe
extends ProbeSkeleton {
    private Set<Probe> probes = new HashSet<Probe>();

    MultiplexProbe(Method m, Set<Provider> providers) {
        super(m.getParameterTypes());
        for (Provider p : providers) {
            Probe probe = p.getProbe(m);
            if (probe == null) continue;
            this.probes.add(probe);
        }
    }

    @Override
    public boolean isEnabled() {
        for (Probe p : this.probes) {
            if (!p.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void uncheckedTrigger(Object[] args) {
        for (Probe p : this.probes) {
            try {
                ProbeSkeleton ps = (ProbeSkeleton)p;
                ps.uncheckedTrigger(args);
            }
            catch (ClassCastException e) {
                try {
                    Method m = Probe.class.getMethod("trigger", Class.forName("[java.lang.Object"));
                    m.invoke((Object)p, args);
                }
                catch (Exception e1) {
                    assert (false);
                }
            }
        }
    }
}

