/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.StageVals;
import ch.cern.sparkmeasure.TaskVals;
import ch.cern.sparkmeasure.Utils;
import java.io.FileInputStream;
import java.nio.file.Paths;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Utils$ {
    public static final Utils$ MODULE$;

    static {
        new Utils$();
    }

    public String formatDuration(long milliseconds) {
        if (milliseconds < 100L) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)milliseconds)}));
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < 1.0) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        if (seconds < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)10) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        if (minutes < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        double hours = minutes / (double)60;
        return new StringOps(Predef$.MODULE$.augmentString("%.1f h")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)hours)}));
    }

    public String formatBytes(long bytes) {
        Tuple2 tuple2;
        long trillion = 0x10000000000L;
        long billion = 0x40000000L;
        long million = 0x100000L;
        long thousand = 1024L;
        Tuple2 tuple22 = bytes >= 2L * trillion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / trillion)), (Object)" TB") : (bytes >= 2L * billion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / billion)), (Object)" GB") : (bytes >= 2L * million ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / million)), (Object)" MB") : (tuple2 = bytes >= 2L * thousand ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / thousand)), (Object)" KB") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)bytes), (Object)" Bytes"))));
        if (tuple2 != null) {
            String unit;
            Tuple2 tuple23;
            double value = tuple2._1$mcD$sp();
            String unit2 = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)value), (Object)unit2);
            double value2 = tuple24._1$mcD$sp();
            String string = unit = (String)tuple24._2();
            String string2 = " Bytes";
            return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString("%d%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)value2)), unit})) : new StringOps(Predef$.MODULE$.augmentString("%.1f%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value2), unit}));
        }
        throw new MatchError((Object)tuple2);
    }

    public String preattyPrintValues(String metric, long value) {
        String name = metric.toLowerCase();
        String basicValue = ((Object)BoxesRunTime.boxToLong((long)value)).toString();
        String optionalValueWithUnits = name.contains("time") || name.contains("duration") ? new StringBuilder().append((Object)" (").append((Object)this.formatDuration(value)).append((Object)")").toString() : (name.contains("bytes") || name.contains("size") ? new StringBuilder().append((Object)" (").append((Object)this.formatBytes(value)).append((Object)")").toString() : "");
        return new StringBuilder().append((Object)metric).append((Object)" => ").append((Object)basicValue).append((Object)optionalValueWithUnits).toString();
    }

    public <T> ListBuffer<T> readSerialized(String stageMetricsFileName) {
        String fullPath = ((Object)Paths.get(stageMetricsFileName, new String[0])).toString();
        Utils.ObjectInputStreamWithCustomClassLoader ois = new Utils.ObjectInputStreamWithCustomClassLoader(new FileInputStream(fullPath));
        ListBuffer result = (ListBuffer)ois.readObject();
        return result;
    }

    public ListBuffer<StageVals> readSerializedStageMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    public ListBuffer<TaskVals> readSerializedTaskMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    private Utils$() {
        MODULE$ = this;
    }
}

