/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import com.google.common.base.Predicate;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class Utils {
    public static Predicate<String> NOT_EMPTY = new Predicate<String>(){

        public boolean apply(String input) {
            return null != input && input.trim().length() != 0;
        }
    };

    public static <T> T checkNull(String name, T value) {
        if (null == value) {
            throw new IllegalArgumentException(name + " can't be null");
        }
        return value;
    }

    public static String checkNull(String name, String value) {
        if (null == value) {
            throw new IllegalArgumentException(name + " can't be null");
        }
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException(name + " can't be empty or be constituted only of spaces");
        }
        return value;
    }

    public static <T> Collection<T> checkEmpty(String name, Collection<T> collection) {
        Utils.checkNull(name, collection);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(name + " can't be empty");
        }
        return collection;
    }

    public static boolean hasCause(Throwable exception, Class<? extends Throwable> causeClass) {
        if (null == exception) {
            return false;
        }
        do {
            if (!exception.getClass().equals(causeClass)) continue;
            return true;
        } while (null != (exception = exception.getCause()));
        return false;
    }

    public static <T> T checkNullState(String message, T value) {
        if (null == value) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static double round(double value, int power) {
        double scaled = Math.scalb(value, -power);
        return Math.scalb(Math.rint(scaled), power);
    }

    public static <T> String join(Iterable<T> sequence, String delimiter) {
        Iterator<T> iterator;
        if (null == sequence) {
            return "null";
        }
        if (null == delimiter) {
            delimiter = "";
        }
        if (!(iterator = sequence.iterator()).hasNext()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(iterator.next());
        while (iterator.hasNext()) {
            buffer.append(delimiter);
            buffer.append(iterator.next());
        }
        return buffer.toString();
    }

    public static <T> List<T> drainQueue(Queue<T> queue) {
        T newValue;
        Utils.checkNull("Queue", queue);
        LinkedList<T> drainedList = new LinkedList<T>();
        while (null != (newValue = queue.poll())) {
            drainedList.add(newValue);
        }
        return drainedList;
    }

    public static <T> T getUnique(Collection<T> collection) {
        Utils.checkNull("Collection", collection);
        if (collection.size() != 1) {
            throw new IllegalArgumentException("Collection " + collection + " is expected to contain only one element");
        }
        return collection.iterator().next();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }
}

