/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.GlobalReference;
import cern.entwined.Memory;
import cern.entwined.SemiPersistent;
import cern.entwined.TransactionAdapter;
import cern.entwined.Utils;

public abstract class STMUtils {
    public static <T> GlobalReference<T> reference(Memory<?> memory, GlobalReference<T> globalReference, T value) {
        Utils.checkNull("Memory", memory);
        if (null != globalReference) {
            globalReference.set(value);
            return globalReference;
        }
        globalReference = new GlobalReference<T>(memory, value);
        return globalReference;
    }

    public static <T> T dereference(GlobalReference<T> reference) {
        if (null != reference) {
            return reference.get();
        }
        return null;
    }

    public static <T extends SemiPersistent<T>> boolean inTransaction(Memory<T> memory) {
        Utils.checkNull("Memory", memory);
        final boolean[] inTransactionBox = new boolean[]{true};
        memory.runTransaction(new TransactionAdapter<T>(){

            @Override
            public void committed(T data) {
                inTransactionBox[0] = false;
            }
        });
        return inTransactionBox[0];
    }
}

