/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class Node<T> {
    private final T value;
    private Node<T> parent = null;
    private final List<Node<T>> children;

    public Node(T value) {
        this.value = value;
        this.children = new ArrayList<Node<T>>();
    }

    public List<Node<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public void addChild(Node<T> child) {
        Utils.checkNull("Child node", child);
        if (null != child.parent) {
            throw new IllegalArgumentException("Added element is a child of another node");
        }
        child.parent = this;
        this.children.add(child);
    }

    public Node<T> removeChild() {
        int childrenLen = this.children.size();
        if (childrenLen != 0) {
            Node<T> child = this.children.remove(childrenLen - 1);
            child.parent = null;
            return child;
        }
        return null;
    }

    public T getValue() {
        return this.value;
    }

    public Node<T> getParent() {
        return this.parent;
    }

    public String toString() {
        return super.toString() + ", value=" + String.valueOf(this.value);
    }
}

