/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.SemiPersistent;
import cern.entwined.Utils;
import cern.entwined.exception.ConflictException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class TransactionalQueue<E>
extends SemiPersistent<TransactionalQueue<E>>
implements Queue<E> {
    private final ListIterator<?> EMPTY_ITERATOR = Collections.EMPTY_LIST.listIterator();
    private final List<E> sourceQueue;
    private final int globalPollCount;
    private ListIterator<E> sourceIterator;
    private List<E> tail;
    private int pollCount = 0;
    private int peekCount = 0;

    public TransactionalQueue() {
        this(Collections.EMPTY_LIST);
    }

    public TransactionalQueue(Collection<E> sourceCollection) {
        Utils.checkNull("Source collection", sourceCollection);
        this.sourceQueue = new LinkedList<E>(sourceCollection);
        this.globalPollCount = 0;
        this.sourceIterator = this.sourceQueue.listIterator();
        this.tail = new LinkedList();
    }

    private TransactionalQueue(List<E> source, int globalPollCount, ListIterator<E> sourceIterator, List<E> tail) {
        Utils.checkNull("Source list", source);
        this.sourceQueue = source;
        this.globalPollCount = globalPollCount;
        this.sourceIterator = sourceIterator;
        this.tail = tail;
    }

    @Override
    protected TransactionalQueue<E> cleanCopy() {
        return new TransactionalQueue<E>(this.sourceQueue, this.globalPollCount, this.sourceQueue.listIterator(), new LinkedList());
    }

    @Override
    protected TransactionalQueue<E> dirtyCopy() {
        TransactionalQueue<E> copy = new TransactionalQueue<E>(this.sourceQueue, this.globalPollCount, this.sourceQueue.listIterator(Math.min(this.sourceQueue.size(), this.pollCount)), new LinkedList<E>(this.tail));
        copy.peekCount = this.peekCount;
        copy.pollCount = this.pollCount;
        return copy;
    }

    @Override
    protected void update(TransactionalQueue<E> changes, boolean onlyReadLogs) {
        Utils.checkNull("Local changes", changes);
        if (this.sourceQueue != changes.sourceQueue) {
            throw new IllegalArgumentException("Updates are only possible for collections with the same source");
        }
        this.updatePeekCount(changes.peekCount);
        if (!onlyReadLogs) {
            this.sourceIterator = changes.sourceIterator;
            this.tail = changes.tail;
            this.pollCount = changes.pollCount;
        }
    }

    @Override
    public TransactionalQueue<E> commit(TransactionalQueue<E> globalState) {
        Utils.checkNull("Global state", globalState);
        if (0 != globalState.peekCount || !globalState.tail.isEmpty()) {
            throw new IllegalArgumentException("Global state map must be commited before calling this method");
        }
        if (this.peekCount == 0 && this.tail.isEmpty()) {
            return globalState;
        }
        int sourceSize = this.sourceQueue.size();
        if (this.peekCount != 0) {
            boolean pastSource;
            if (globalState.globalPollCount != this.globalPollCount) {
                throw new ConflictException("Queue's head was updated");
            }
            boolean bl = pastSource = this.peekCount > sourceSize;
            if (pastSource && globalState.sourceQueue != this.sourceQueue) {
                throw new ConflictException("Reading past source queue with tail concurrently updated");
            }
        }
        if (this.pollCount == 0 && this.tail.isEmpty()) {
            return globalState;
        }
        int globalSize = globalState.sourceQueue.size();
        LinkedList<E> resultingList = new LinkedList<E>(globalState.sourceQueue.subList(Math.min(this.pollCount, globalSize), globalSize));
        resultingList.addAll(this.tail);
        TransactionalQueue<E> result = new TransactionalQueue<E>(resultingList, globalState.globalPollCount + this.pollCount, this.EMPTY_ITERATOR, Collections.EMPTY_LIST);
        return result;
    }

    private void updatePeekCount(int newValue) {
        this.peekCount = Math.max(newValue, this.peekCount);
    }

    public void drainTo(Collection<E> collection) {
        Utils.checkNull("Receiving collection", collection);
        E elem = this.poll();
        while (elem != null) {
            collection.add(elem);
            elem = this.poll();
        }
    }

    @Override
    public boolean offer(E e) {
        Utils.checkNull("Element", e);
        return this.tail.add(e);
    }

    @Override
    public E peek() {
        E result;
        int newPeekCount = this.pollCount;
        if (this.sourceIterator.hasNext()) {
            result = this.sourceIterator.next();
            this.sourceIterator.previous();
            ++newPeekCount;
        } else {
            int tailSize = this.tail.size();
            if (tailSize > 0) {
                ++newPeekCount;
                result = this.tail.get(0);
            } else {
                result = null;
            }
        }
        this.updatePeekCount(newPeekCount);
        return result;
    }

    @Override
    public E poll() {
        E result;
        if (this.sourceIterator.hasNext()) {
            ++this.pollCount;
            result = this.sourceIterator.next();
        } else {
            int tailSize = this.tail.size();
            if (tailSize > 0) {
                ++this.pollCount;
                result = this.tail.remove(0);
            } else {
                result = null;
            }
        }
        this.updatePeekCount(this.pollCount);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return null == this.peek();
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        int sourceSize = this.sourceIterator.hasNext() ? this.sourceQueue.size() - this.pollCount : 0;
        return sourceSize + this.tail.size();
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public E element() {
        E x = this.peek();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E remove() {
        E x = this.poll();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Utils.checkNull("Collection being added", c);
        if (c == this) {
            throw new IllegalArgumentException("Cannot add to itself");
        }
        Iterator<E> e = c.iterator();
        boolean modified = e.hasNext();
        while (e.hasNext()) {
            this.add(e.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }
}

