/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.OpaqueMultimap;
import cern.entwined.SemiPersistent;
import cern.entwined.TransactionalMap;
import cern.entwined.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransactionalMultimap<K, V>
extends SemiPersistent<TransactionalMultimap<K, V>>
implements OpaqueMultimap<K, V> {
    private final TransactionalMap<K, Set<V>> delegate;

    public TransactionalMultimap() {
        this(new TransactionalMap());
    }

    private TransactionalMultimap(TransactionalMap<K, Set<V>> source) {
        this.delegate = source;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<V> get(K key) {
        Set<V> result = this.delegate.get(key);
        if (null != result) {
            return result;
        }
        return ImmutableSet.of();
    }

    private Set<V> unsafePut(K key, Set<V> value) {
        if (value.isEmpty()) {
            return this.remove(key);
        }
        ImmutableSet replaced = this.delegate.put(key, Collections.unmodifiableSet(value));
        return null != replaced ? replaced : ImmutableSet.of();
    }

    @Override
    public Set<V> remove(K key) {
        ImmutableSet result = this.delegate.remove(key);
        return null != result ? result : ImmutableSet.of();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> map) {
        Utils.checkNull("Inserted map", map);
        for (Map.Entry<K, Set<V>> pair : map.entrySet()) {
            this.putAll(pair.getKey(), (Collection)pair.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<V> put(K key, V value) {
        Set<V> oldSet = this.delegate.get(key);
        if (null != oldSet) {
            HashSet<V> newSet = new HashSet<V>(oldSet);
            newSet.add(value);
            return this.unsafePut(key, newSet);
        }
        return this.unsafePut(key, Collections.singleton(value));
    }

    public Set<V> putAll(K key, Collection<V> values) {
        HashSet<V> newSet;
        Utils.checkNull("Values", values);
        Set<V> oldSet = this.delegate.get(key);
        if (null != oldSet) {
            newSet = new HashSet<V>(oldSet);
            newSet.addAll(values);
        } else {
            newSet = new HashSet<V>(values);
        }
        return this.unsafePut(key, newSet);
    }

    public Set<V> remove(K key, V value) {
        Set<V> oldSet = this.delegate.get(key);
        if (null != oldSet) {
            ImmutableSet newSet = Sets.difference(oldSet, Collections.singleton(value)).immutableCopy();
            return this.unsafePut(key, (Set<V>)newSet);
        }
        return this.remove(key);
    }

    @Override
    public TransactionalMultimap<K, V> commit(TransactionalMultimap<K, V> globalState) {
        return new TransactionalMultimap<K, V>(this.delegate.commit(globalState.delegate));
    }

    @Override
    protected TransactionalMultimap<K, V> cleanCopy() {
        return new TransactionalMultimap<K, V>(this.delegate.cleanCopy());
    }

    @Override
    protected TransactionalMultimap<K, V> dirtyCopy() {
        return new TransactionalMultimap<K, V>(this.delegate.dirtyCopy());
    }

    @Override
    protected void update(TransactionalMultimap<K, V> changes, boolean onlyReadLogs) {
        this.delegate.update(changes.delegate, onlyReadLogs);
    }
}

