/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.OpaqueMap;
import cern.entwined.SemiPersistent;
import cern.entwined.Utils;
import cern.entwined.exception.ConflictException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TransactionalMap<K, V>
extends SemiPersistent<TransactionalMap<K, V>>
implements OpaqueMap<K, V> {
    private final Map<K, V> sourceMap;
    private final Map<K, V> pendingModifications = new HashMap();
    private final Set<K> pendingDeletions = new HashSet<K>();
    private final Set<K> accessed = new HashSet<K>();
    private boolean globallyAccessed = false;
    private boolean cleared = false;

    public TransactionalMap() {
        this(Collections.EMPTY_MAP, false);
    }

    public TransactionalMap(Map<K, V> sourceMap) {
        this(sourceMap, true);
    }

    private TransactionalMap(Map<K, V> sourceMap, boolean cloneSource) {
        Utils.checkNull("Source map", sourceMap);
        this.sourceMap = cloneSource ? Collections.unmodifiableMap(new HashMap<K, V>(sourceMap)) : sourceMap;
    }

    @Override
    public int size() {
        this.markGloballyAccessed();
        Sets.SetView keys = Sets.union(this.sourceMap.keySet(), this.pendingModifications.keySet());
        return keys.size() - this.pendingDeletions.size();
    }

    @Override
    public boolean isEmpty() {
        boolean empty;
        boolean bl = empty = this.sourceMap.size() == this.pendingDeletions.size() && this.pendingModifications.isEmpty();
        if (empty) {
            this.markGloballyAccessed();
        }
        return empty;
    }

    @Override
    public void clear() {
        this.markCleared();
        this.pendingDeletions.addAll(this.sourceMap.keySet());
        this.pendingModifications.clear();
    }

    @Override
    public boolean containsKey(K key) {
        this.markAccessed(key);
        return (this.sourceMap.containsKey(key) || this.pendingModifications.containsKey(key)) && !this.pendingDeletions.contains(key);
    }

    @Override
    public V get(K key) {
        this.markAccessed(key);
        if (this.pendingDeletions.contains(key)) {
            return null;
        }
        if (this.pendingModifications.containsKey(key)) {
            return this.pendingModifications.get(key);
        }
        return this.sourceMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.accessed.add(key);
        this.pendingDeletions.remove(key);
        V oldValue = this.pendingModifications.put(key, value);
        return null != oldValue ? oldValue : this.sourceMap.get(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Utils.checkNull("Map", m);
        this.accessed.addAll(m.keySet());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(K key) {
        V oldValue = this.get(key);
        if (this.sourceMap.containsKey(key)) {
            this.pendingDeletions.add(key);
        }
        this.pendingModifications.remove(key);
        return oldValue;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public TransactionalMap<K, V> cleanCopy() {
        return new TransactionalMap<K, V>(this.sourceMap, false);
    }

    @Override
    protected TransactionalMap<K, V> dirtyCopy() {
        TransactionalMap<K, V> copy = new TransactionalMap<K, V>(this.sourceMap, false);
        copy.globallyAccessed = this.globallyAccessed;
        super.markAccessed((Collection<K>)this.accessed);
        copy.pendingDeletions.addAll(this.pendingDeletions);
        copy.pendingModifications.putAll(this.pendingModifications);
        return copy;
    }

    @Override
    protected void update(TransactionalMap<K, V> changes, boolean onlyReadLogs) {
        Utils.checkNull("Local changes", changes);
        if (this.sourceMap != changes.sourceMap) {
            throw new IllegalArgumentException("Updates are only possible for collections with the same source");
        }
        if (changes.globallyAccessed) {
            this.markGloballyAccessed();
        }
        this.markAccessed((Collection<K>)changes.accessed);
        if (!onlyReadLogs) {
            this.pendingModifications.clear();
            this.pendingModifications.putAll(changes.pendingModifications);
            this.pendingDeletions.clear();
            this.pendingDeletions.addAll(changes.pendingDeletions);
        }
    }

    @Override
    public TransactionalMap<K, V> commit(TransactionalMap<K, V> globalState) {
        Utils.checkNull("Global state", globalState);
        if (!globalState.pendingDeletions.isEmpty() || !globalState.pendingModifications.isEmpty() || !globalState.accessed.isEmpty() || globalState.globallyAccessed) {
            throw new IllegalArgumentException("Global state map must be commited before calling this method");
        }
        if (this.globallyAccessed && !globalState.sourceMap.equals(this.sourceMap)) {
            throw new ConflictException("All the items of this map have been accessed this prohibits commit in the case of concurrent changes");
        }
        for (K key : this.accessed) {
            this.checkConsistency(globalState.sourceMap, key);
        }
        if (this.pendingDeletions.isEmpty() && this.pendingModifications.isEmpty()) {
            return globalState;
        }
        HashMap<K, V> globalMapCopy = new HashMap<K, V>(globalState.sourceMap);
        for (Map.Entry<K, V> entry : this.pendingModifications.entrySet()) {
            globalMapCopy.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<K, V> key : this.pendingDeletions) {
            globalMapCopy.remove(key);
        }
        return new TransactionalMap<K, V>(globalMapCopy);
    }

    private void markAccessed(K key) {
        if (!this.globallyAccessed) {
            this.accessed.add(key);
        }
    }

    private void markAccessed(Collection<K> keys) {
        if (!this.globallyAccessed) {
            this.accessed.addAll(keys);
        }
    }

    private void markGloballyAccessed() {
        if (!this.cleared) {
            this.globallyAccessed = true;
            this.accessed.clear();
        }
    }

    private void markCleared() {
        if (!this.globallyAccessed) {
            this.cleared = true;
            this.markAccessed((Collection<K>)this.sourceMap.keySet());
        }
    }

    private void checkConsistency(Map<K, V> globalMap, K key) {
        V globalValue;
        V sourceValue = this.sourceMap.get(key);
        if (sourceValue != (globalValue = globalMap.get(key)) || (null == sourceValue || null == globalValue) && this.sourceMap.containsKey(key) ^ globalMap.containsKey(key)) {
            throw new ConflictException("Conflicting changes for [" + key + "]");
        }
    }

    private class KeyIterator
    implements Iterator<K> {
        private final Iterator<K> keyIterator;

        public KeyIterator() {
            Iterator unfiltered = Iterators.concat(TransactionalMap.this.sourceMap.keySet().iterator(), TransactionalMap.this.pendingModifications.keySet().iterator());
            this.keyIterator = Iterators.filter((Iterator)unfiltered, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)TransactionalMap.this.pendingDeletions)));
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.keyIterator.hasNext();
            if (!hasNext) {
                TransactionalMap.this.markGloballyAccessed();
            }
            return hasNext;
        }

        @Override
        public K next() {
            try {
                return this.keyIterator.next();
            }
            catch (NoSuchElementException ex) {
                TransactionalMap.this.markGloballyAccessed();
                throw ex;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return TransactionalMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return TransactionalMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return TransactionalMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            boolean result = TransactionalMap.this.containsKey(o);
            TransactionalMap.this.remove(o);
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator<?> i = c.iterator();
            while (i.hasNext()) {
                modified |= this.remove(i.next());
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            TransactionalMap.this.clear();
        }
    }
}

