/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.BaseSnapshot;
import cern.entwined.Node;
import cern.entwined.SemiPersistent;
import cern.entwined.Transaction;
import cern.entwined.Utils;
import cern.entwined.exception.ConflictException;
import cern.entwined.exception.InvocationException;
import cern.entwined.exception.MemoryException;
import cern.entwined.exception.NoTransactionException;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Memory<T extends SemiPersistent<T>> {
    protected static final int NUM_RETRIES = 10000;
    private volatile BaseSnapshot<T> globalSnapshot;
    private final AtomicLong idSequence = new AtomicLong(0L);
    private final ReadWriteLock accessLock = new ReentrantReadWriteLock();
    private final ThreadLocal<LinkedList<BaseSnapshot<T>>> threadLocalSnapshots = new ThreadLocal();
    private final ThreadLocal<Node<Transaction<T>>> currentNode = new ThreadLocal();
    private final ConcurrentLinkedQueue<BaseSnapshot<T>> commitQueue = new ConcurrentLinkedQueue();
    private final ThreadLocal<Boolean> isCommitting = new ThreadLocal();

    public Memory(T initialState) {
        Utils.checkNull("Initial State", initialState);
        this.globalSnapshot = new BaseSnapshot<SemiPersistent>(0L, (SemiPersistent)((SemiPersistent)initialState).cleanCopy());
    }

    public boolean runTransaction(Transaction<T> transaction) {
        Utils.checkNull("Transaction callback", transaction);
        if (Boolean.TRUE == this.isCommitting.get()) {
            throw new MemoryException("Cannot run transaction within committed block.");
        }
        if (null == this.currentNode.get()) {
            return this.execOuterTransaction(transaction);
        }
        return this.execInnerTransaction(transaction);
    }

    protected BaseSnapshot<T> getBaseSnapshot() {
        LinkedList<BaseSnapshot<T>> stack = this.getSnapshotStack();
        if (stack.isEmpty()) {
            throw new NoTransactionException("There is no running transaction, cannot access the base snapshot");
        }
        return stack.peek();
    }

    protected Long getNextId() {
        return this.idSequence.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execOuterTransaction(Transaction<T> transaction) {
        BaseSnapshot<T> newGlobalState;
        Node<Transaction<T>> transactionNode;
        int retryIdx = 0;
        while (true) {
            BaseSnapshot<T> transactionSnapshot = this.cleanCopyGlobalSnapshot();
            transactionNode = new Node<Transaction<T>>(transaction);
            this.currentNode.set(transactionNode);
            try {
                if (!this.invokeUserCode(transaction, transactionSnapshot, this.getSnapshotStack())) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.currentNode.set(null);
                this.threadLocalSnapshots.get().clear();
            }
            try {
                newGlobalState = this.commitSnapshot(transactionSnapshot);
            }
            catch (ConflictException ex) {
                if (++retryIdx <= 10000) continue;
                throw ex;
            }
            break;
        }
        try {
            this.waitItsTurn(newGlobalState);
            this.isCommitting.set(true);
            this.postorder(transactionNode, newGlobalState);
        }
        finally {
            this.commitQueue.poll();
            this.isCommitting.set(false);
        }
        return true;
    }

    private void postorder(Node<Transaction<T>> node, BaseSnapshot<T> snapshot) {
        for (Node<Transaction<T>> child : node.getChildren()) {
            this.postorder(child, snapshot);
        }
        LinkedList<BaseSnapshot<T>> stack = this.getSnapshotStack();
        try {
            Object cleanCopy = snapshot.cleanCopy();
            stack.push((BaseSnapshot<T>)cleanCopy);
            node.getValue().committed(((BaseSnapshot)cleanCopy).getClientData());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationException("Exception in committed block", e);
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execInnerTransaction(Transaction<T> transaction) {
        LinkedList<BaseSnapshot<T>> snapshotStack = this.getSnapshotStack();
        Node<Transaction<T>> childNode = new Node<Transaction<T>>(transaction);
        Object innerSnapshot = snapshotStack.peek().dirtyCopy();
        Node<Transaction<Transaction<T>>> parentNode = this.currentNode.get();
        parentNode.addChild(childNode);
        this.currentNode.set(childNode);
        boolean success = false;
        try {
            success = this.invokeUserCode(transaction, (BaseSnapshot<T>)innerSnapshot, snapshotStack);
        }
        finally {
            this.currentNode.set(parentNode);
            BaseSnapshot<T> outerSnapshot = snapshotStack.peek();
            if (!success) {
                parentNode.removeChild();
                outerSnapshot.update((BaseSnapshot<T>)innerSnapshot, true);
            } else {
                outerSnapshot.update((BaseSnapshot<T>)innerSnapshot, false);
            }
        }
        return success;
    }

    private boolean invokeUserCode(Transaction<T> transaction, BaseSnapshot<T> transactionSnapshot, LinkedList<BaseSnapshot<T>> snapshotStack) {
        snapshotStack.push(transactionSnapshot);
        try {
            boolean bl = transaction.run(transactionSnapshot.getClientData());
            return bl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationException("Exception in the transactional code", e);
        }
        finally {
            snapshotStack.poll();
        }
    }

    private LinkedList<BaseSnapshot<T>> getSnapshotStack() {
        LinkedList<BaseSnapshot<Object>> snapshotStack = this.threadLocalSnapshots.get();
        if (null == snapshotStack) {
            snapshotStack = new LinkedList();
            this.threadLocalSnapshots.set(snapshotStack);
        }
        return snapshotStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseSnapshot<T> commitSnapshot(BaseSnapshot<T> transactionSnapshot) {
        this.accessLock.writeLock().lock();
        try {
            BaseSnapshot<T> committedSnapshot = transactionSnapshot.commit(this.globalSnapshot);
            this.globalSnapshot = committedSnapshot;
            this.commitQueue.add(committedSnapshot);
            BaseSnapshot<T> baseSnapshot = committedSnapshot;
            return baseSnapshot;
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
    }

    private BaseSnapshot<T> cleanCopyGlobalSnapshot() {
        Object snapshotCopy = this.globalSnapshot.cleanCopy();
        return snapshotCopy;
    }

    private void waitItsTurn(BaseSnapshot<T> newGlobalState) {
        boolean interrupted = false;
        while (this.commitQueue.peek() != newGlobalState) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

