/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.SemiPersistent;
import cern.entwined.Snapshot;
import cern.entwined.TransactionalMap;
import cern.entwined.Utils;

class BaseSnapshot<V extends SemiPersistent<V>>
extends Snapshot<BaseSnapshot<V>> {
    private final TransactionalMap<Long, Object> globalMap;
    private final V clientData;

    public BaseSnapshot(long timestamp, V snapshot) {
        this(timestamp, snapshot, new TransactionalMap<Long, Object>());
    }

    public BaseSnapshot(long timestamp, V snapshot, TransactionalMap<Long, Object> globalMap) {
        super(timestamp);
        Utils.checkNull("Snapshot", snapshot);
        Utils.checkNull("Global map", globalMap);
        this.clientData = snapshot;
        this.globalMap = globalMap;
    }

    protected TransactionalMap<Long, Object> getGlobalMap() {
        return this.globalMap;
    }

    protected V getClientData() {
        return this.clientData;
    }

    @Override
    protected BaseSnapshot<V> cleanCopy() {
        return new BaseSnapshot<SemiPersistent>(this.timestamp, (SemiPersistent)((SemiPersistent)this.clientData).cleanCopy(), (TransactionalMap<Long, Object>)this.globalMap.cleanCopy());
    }

    @Override
    protected BaseSnapshot<V> dirtyCopy() {
        return new BaseSnapshot<SemiPersistent>(this.timestamp, (SemiPersistent)((SemiPersistent)this.clientData).dirtyCopy(), (TransactionalMap<Long, Object>)this.globalMap.dirtyCopy());
    }

    @Override
    protected void update(BaseSnapshot<V> changes, boolean onlyReadLogs) {
        Utils.checkNull("Changes", changes);
        if (this.timestamp != changes.timestamp) {
            throw new IllegalArgumentException("Updates are only possible from dirty copies of this snapshot");
        }
        ((SemiPersistent)this.clientData).update(changes.clientData, onlyReadLogs);
        this.globalMap.update(changes.globalMap, onlyReadLogs);
    }

    @Override
    public BaseSnapshot<V> commit(BaseSnapshot<V> globalState) {
        Utils.checkNull("Global state", globalState);
        return new BaseSnapshot<SemiPersistent>(this.timestamp + 1L, (SemiPersistent)this.clientData.commit(globalState.clientData), this.globalMap.commit(globalState.globalMap));
    }
}

