/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.dirq.test;

import ch.cern.dirq.Queue;
import ch.cern.dirq.QueueSimple;
import ch.cern.mig.posix.Posix;
import ch.cern.mig.utils.ProcessUtils;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.CommandLineInterface;
import com.lexicalscope.jewel.cli.Option;
import com.lexicalscope.jewel.cli.Unparsed;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TestDirq {
    private static final List<String> TESTS = Arrays.asList("add", "count", "size", "get", "iterate", "purge", "remove", "simple");
    private static final int pid = Posix.posix.getpid();
    private static final SimpleDateFormat DBGDATEFMT = new SimpleDateFormat("yyyy/MM/dd-kk:mm:ss");
    private List<String> tests = null;
    private TestDirQArgs options = null;

    private TestDirQArgs parseArguments(String[] args) {
        TestDirQArgs parsed = null;
        try {
            parsed = (TestDirQArgs)CliFactory.parseArguments(TestDirQArgs.class, (String[])args);
            if (parsed.getList()) {
                System.out.print("Available tests:");
                for (String test : TESTS) {
                    System.out.print(" " + test);
                }
                System.out.println("");
                System.exit(0);
            }
            if (parsed.getTest().equals("")) {
                throw new ArgumentValidationException("missing test name");
            }
            if (!TESTS.contains(parsed.getTest())) {
                throw new ArgumentValidationException("test name not valid: " + parsed.getTest());
            }
            if (parsed.getType().equals("normal")) {
                throw new ArgumentValidationException("unsupported DirQ type: " + parsed.getType());
            }
            if (!parsed.getType().equals("simple")) {
                throw new ArgumentValidationException("unexpected DirQ type: " + parsed.getType());
            }
            this.tests = new ArrayList<String>();
            this.tests.add(parsed.getTest());
        }
        catch (ArgumentValidationException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return parsed;
    }

    private Queue newDirq() throws IOException {
        if (!this.options.getType().equals("simple")) {
            throw new IllegalArgumentException("only DirQ simple is supported");
        }
        QueueSimple queue = new QueueSimple(this.options.getPath());
        if (this.options.getGranularity() > -1) {
            queue.setGranularity(this.options.getGranularity());
        }
        if (this.options.getRndhex() > -1) {
            queue.setRndHex(this.options.getRndhex());
        }
        if (this.options.getUmask() > -1) {
            queue.setUmask(this.options.getUmask());
        }
        return queue;
    }

    private void testSize() {
        Map res = ProcessUtils.executeIt((String)("du -ks " + this.options.getPath()));
        int exitValue = Integer.parseInt((String)res.get("exitValue"));
        if (exitValue > 0) {
            TestDirq.die("du failed: " + exitValue);
        }
        this.debug("du output: " + (String)res.get("out"));
    }

    private void testCount() throws IOException {
        Queue queue = this.newDirq();
        int count = queue.count();
        this.debug(String.format("queue has %d elements", count));
    }

    private void testPurge() throws IOException {
        this.debug("purging the queue...");
        Queue queue = this.newDirq();
        Integer maxLock = null;
        Integer maxTemp = null;
        if (this.options.getMaxlock() > -1) {
            maxLock = this.options.getMaxlock();
        }
        if (this.options.getMaxtemp() > -1) {
            maxTemp = this.options.getMaxtemp();
        }
        queue.purge(maxLock, maxTemp);
    }

    private void testGet() throws IOException {
        this.debug("getting all elements in the queue (one pass)...");
        Queue queue = this.newDirq();
        int done = 0;
        for (String element : queue) {
            if (!queue.lock(element)) continue;
            queue.get(element);
            queue.unlock(element);
            ++done;
        }
        this.debug(String.format("got %d elements", done));
    }

    private void testIterate() throws IOException {
        this.debug("iterating all elements in the queue (one pass)...");
        Queue queue = this.newDirq();
        int done = 0;
        for (String element : queue) {
            if (!queue.lock(element)) continue;
            queue.unlock(element);
            ++done;
        }
        this.debug(String.format("iterated %d elements", done));
    }

    private String newBody(int size, boolean random) {
        if (random) {
            double rnd = 0.0;
            for (int i = 0; i < 12; ++i) {
                rnd += Math.random();
            }
            rnd -= 6.0;
            rnd *= (double)(size / 6);
            size += (int)rnd;
        }
        if (size < 1) {
            return "";
        }
        char[] charArray = new char[size];
        Arrays.fill(charArray, 'A');
        return new String(charArray);
    }

    private void testAdd() throws IOException {
        boolean random = this.options.isRandom();
        int size = this.options.getSize();
        int count = this.options.getCount();
        if (count > -1) {
            this.debug(String.format("adding %d elements to the queue...", count));
        } else {
            this.debug("adding elements to the queue forever...");
        }
        Queue queue = this.newDirq();
        int done = 0;
        while (count == -1 || done < count) {
            String element = size > -1 ? this.newBody(size, random) : "Element " + ++done;
            queue.add(element);
        }
        this.debug(String.format("added %d elements", done));
    }

    private void testRemove() throws IOException {
        int count = this.options.getCount();
        if (count > -1) {
            this.debug(String.format("removing %d elements from the queue...", count));
        } else {
            this.debug("removing all elements from the queue (one pass)...");
        }
        Queue queue = this.newDirq();
        int done = 0;
        if (count > -1) {
            block0: while (done < count) {
                for (String element : queue) {
                    if (!queue.lock(element)) continue;
                    queue.remove(element);
                    if (++done != count) continue;
                    continue block0;
                }
            }
        } else {
            for (String element : queue) {
                if (!queue.lock(element)) continue;
                queue.remove(element);
                ++done;
            }
            this.debug(String.format("removed %d elements", done));
        }
    }

    private void testSimple() throws IOException {
        File path = new File(this.options.getPath());
        if (path.exists()) {
            TestDirq.die("directory exists: " + path);
        }
        if (this.options.getCount() == -1) {
            TestDirq.die("missing option: --count");
        }
        this.testAdd();
        this.testCount();
        this.testSize();
        this.testPurge();
        this.testGet();
        this.testRemove();
        this.testPurge();
        int num = path.listFiles().length;
        if (num != 1) {
            throw new IllegalArgumentException("unexpected subdirs number: " + num);
        }
        TestDirq.deleteRecursively(path);
    }

    private void runTest(String name) throws IOException {
        long t1 = System.currentTimeMillis();
        if (name.equals("add")) {
            this.testAdd();
        } else if (name.equals("count")) {
            this.testCount();
        } else if (name.equals("get")) {
            this.testGet();
        } else if (name.equals("iterate")) {
            this.testIterate();
        } else if (name.equals("purge")) {
            this.testPurge();
        } else if (name.equals("remove")) {
            this.testRemove();
        } else if (name.equals("simple")) {
            this.testSimple();
        } else if (name.equals("size")) {
            this.testSize();
        } else {
            throw new IllegalArgumentException("unexpected test name: " + name);
        }
        long t2 = System.currentTimeMillis();
        this.debug(String.format("done in %.4f seconds", (double)(t2 - t1) / 1000.0));
    }

    public static boolean deleteRecursively(File path) {
        if (path.isDirectory()) {
            String[] children = path.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = TestDirq.deleteRecursively(new File(path, children[i]));
                if (success) continue;
                return false;
            }
        }
        return path.delete();
    }

    public void mainSimple(String[] args) throws IOException {
        this.options = this.parseArguments(args);
        File path = new File(this.options.getPath());
        TestDirq.deleteRecursively(path);
        try {
            this.testSimple();
        }
        catch (IOException e) {
            TestDirq.deleteRecursively(path);
            throw e;
        }
        TestDirq.deleteRecursively(path);
    }

    public void doMain(String[] args) throws InterruptedException, IOException {
        this.options = this.parseArguments(args);
        if (this.options.getPath().length() == 0) {
            TestDirq.die("Option is mandatory: -p/--path");
        }
        if (this.options.getSleep() > 0) {
            Thread.sleep(this.options.getSleep() * 1000);
        }
        for (String test : this.tests) {
            this.runTest(test);
        }
    }

    private static void die(String message) {
        throw new RuntimeException(message);
    }

    private void debug(String message) {
        if (!this.options.isDebug()) {
            return;
        }
        System.out.print(String.format("# %s TestDirq[%d]: %s\n", DBGDATEFMT.format(new Date()), pid, message));
        System.out.flush();
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        new TestDirq().doMain(args);
    }

    @CommandLineInterface(application="java-dirq-test")
    private static interface TestDirQArgs {
        @Option(shortName={"c"}, longName={"count"}, defaultValue={"-1"}, description="set the elements count")
        public int getCount();

        @Option(shortName={"d"}, longName={"debug"}, description="show debugging information")
        public boolean isDebug();

        @Option(longName={"header"}, description="set header for added elements")
        public boolean isHeader();

        @Option(helpRequest=true, longName={"help"}, description="display help")
        public boolean getHelp();

        @Option(shortName={"l"}, longName={"list"}, description="tests: add count size get iterate purge remove simple")
        public boolean getList();

        @Option(longName={"granularity"}, defaultValue={"-1"}, description="time granularity for intermediate directories (QueueSimple)")
        public int getGranularity();

        @Option(longName={"maxlock"}, defaultValue={"-1"}, description="maximum time for a locked element (or 0 to disable purging)")
        public int getMaxlock();

        @Option(longName={"maxtemp"}, defaultValue={"-1"}, description="maxmum time for a temporary element (or 0 to disable purging)")
        public int getMaxtemp();

        @Option(shortName={"p"}, longName={"path"}, defaultValue={""}, description="set the queue path")
        public String getPath();

        @Option(shortName={"r"}, longName={"random"}, description="randomize the body size")
        public boolean isRandom();

        @Option(longName={"rndhex"}, defaultValue={"-1"}, description="set the random hexadecimal digit for the queue")
        public int getRndhex();

        @Option(shortName={"s"}, longName={"size"}, defaultValue={"-1"}, description="set the body size for added elements")
        public int getSize();

        @Option(longName={"sleep"}, defaultValue={"0"}, description="sleep this amount of seconds before starting")
        public int getSleep();

        @Option(longName={"type"}, defaultValue={"simple"}, description="DirQ type (simple|normal)")
        public String getType();

        @Option(longName={"umask"}, defaultValue={"-1"}, description="set the umask for the queue")
        public int getUmask();

        @Unparsed(name="test", defaultValue={""})
        public String getTest();
    }
}

