/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import ch.carve.microprofile.config.consul.Configuration;
import ch.carve.microprofile.config.consul.ExpiringMap;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulConfigSource
implements ConfigSource {
    private static final Logger logger = LoggerFactory.getLogger(ConsulConfigSource.class);
    private static final String DEFAULT_CONSUL_CONFIGSOURCE_ORDINAL = "550";
    Configuration config = new Configuration();
    ExpiringMap<String, String> cache = new ExpiringMap(this.config.getValidity());
    ConsulClient client = new ConsulClient(this.config.getConsulHost());

    public Map<String, String> getProperties() {
        return this.cache.getMap().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)((ExpiringMap.TimedEntry)e.getValue()).getValue()));
    }

    public String getValue(String propertyName) {
        if ("config_ordinal".equals(propertyName)) {
            return Optional.ofNullable(this.getConsulValue(propertyName)).orElse(DEFAULT_CONSUL_CONFIGSOURCE_ORDINAL);
        }
        return this.cache.getOrCompute(propertyName, p -> this.getConsulValue((String)p), p -> logger.debug("consul getKV failed for key {}", p));
    }

    private String getConsulValue(String propertyName) {
        GetValue value = (GetValue)this.client.getKVValue(this.config.getPrefix() + propertyName).getValue();
        if (value != null) {
            return value.getDecodedValue();
        }
        return null;
    }

    public String getName() {
        return "ConsulConfigSource";
    }
}

